/*
 * Decompiled with CFR 0.152.
 */
package swim.store.mem;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.plane.PlaneContext;
import swim.collections.BTreeMap;
import swim.collections.HashTrieMap;
import swim.collections.STreeList;
import swim.math.Z2Form;
import swim.spatial.QTreeMap;
import swim.store.DataBinding;
import swim.store.ListDataBinding;
import swim.store.MapDataBinding;
import swim.store.SpatialDataBinding;
import swim.store.Storage;
import swim.store.ValueDataBinding;
import swim.store.mem.ListDataModel;
import swim.store.mem.MapDataModel;
import swim.store.mem.SpatialDataModel;
import swim.store.mem.ValueDataModel;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

public class MemStorage
implements Storage {
    volatile HashTrieMap<Value, DataBinding> trees = HashTrieMap.empty();
    static final AtomicReferenceFieldUpdater<MemStorage, HashTrieMap<Value, DataBinding>> TREES = AtomicReferenceFieldUpdater.newUpdater(MemStorage.class, HashTrieMap.class, "trees");

    public void init(PlaneContext planeContext, Value storeSettings) {
    }

    public void init(String path, String basePath, PlaneContext planeContext) {
    }

    public ListDataBinding openListData(Value name) {
        ListDataModel tree = null;
        while (true) {
            HashTrieMap newTrees;
            HashTrieMap<Value, DataBinding> oldTrees;
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (ListDataModel)oldTree;
                continue;
            }
            if (tree == null) {
                tree = new ListDataModel(name, (STreeList<Value>)new STreeList());
            }
            if (TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree)))) break;
        }
        return tree;
    }

    public ListDataBinding openListData(Uri nodeUri, Value name) {
        return this.openListData(this.treeName(nodeUri, name));
    }

    public MapDataBinding openMapData(Value name) {
        MapDataModel tree = null;
        while (true) {
            HashTrieMap newTrees;
            HashTrieMap<Value, DataBinding> oldTrees;
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (MapDataModel)oldTree;
                continue;
            }
            if (tree == null) {
                tree = new MapDataModel(name, (BTreeMap<Value, Value, Value>)new BTreeMap());
            }
            if (TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree)))) break;
        }
        return tree;
    }

    public MapDataBinding openMapData(Uri nodeUri, Value name) {
        return this.openMapData(this.treeName(nodeUri, name));
    }

    public <S> SpatialDataBinding<S> openSpatialData(Value name, Z2Form<S> shapeForm) {
        SpatialDataModel tree = null;
        while (true) {
            HashTrieMap newTrees;
            HashTrieMap<Value, DataBinding> oldTrees;
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (SpatialDataModel)oldTree;
                continue;
            }
            if (tree == null) {
                tree = new SpatialDataModel(name, new QTreeMap(shapeForm));
            }
            if (TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree)))) break;
        }
        return tree;
    }

    public <S> SpatialDataBinding<S> openSpatialData(Uri nodeUri, Value name, Z2Form<S> shapeForm) {
        return this.openSpatialData(this.treeName(nodeUri, name), shapeForm);
    }

    public ValueDataBinding openValueData(Value name) {
        ValueDataModel tree = null;
        while (true) {
            HashTrieMap newTrees;
            HashTrieMap<Value, DataBinding> oldTrees;
            DataBinding oldTree;
            if ((oldTree = (DataBinding)(oldTrees = this.trees).get((Object)name)) != null) {
                tree = (ValueDataModel)oldTree;
                continue;
            }
            if (tree == null) {
                tree = new ValueDataModel(name, Value.absent());
            }
            if (TREES.compareAndSet(this, oldTrees, (HashTrieMap<Value, DataBinding>)(newTrees = oldTrees.updated((Object)name, (Object)tree)))) break;
        }
        return tree;
    }

    public ValueDataBinding openValueData(Uri nodeUri, Value name) {
        return this.openValueData(this.treeName(nodeUri, name));
    }

    public void close() {
    }

    protected Value treeName(Uri nodeUri, Value name) {
        return Record.create((int)2).slot("node", nodeUri.toString()).slot("name", name).commit();
    }
}

