/*
 * Decompiled with CFR 0.152.
 */
package swim.store;

import swim.api.data.ValueData;
import swim.store.ValueDataBinding;
import swim.store.ValueDataContext;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

public class ValueDataView<V>
implements ValueData<V>,
ValueDataContext {
    protected final ValueDataBinding dataBinding;
    protected final Form<V> valueForm;

    public ValueDataView(ValueDataBinding dataBinding, Form<V> valueForm) {
        this.dataBinding = dataBinding;
        this.valueForm = valueForm;
    }

    public ValueDataBinding dataBinding() {
        return this.dataBinding;
    }

    public Value name() {
        return this.dataBinding.name();
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ValueDataView<V2> valueForm(Form<V2> valueForm) {
        return new ValueDataView<V2>(this.dataBinding, valueForm);
    }

    public <V2> ValueDataView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isResident() {
        return this.dataBinding.isResident();
    }

    public ValueDataView<V> isResident(boolean isResident) {
        this.dataBinding.isResident(isResident);
        return this;
    }

    public boolean isTransient() {
        return this.dataBinding.isTransient();
    }

    public ValueDataView<V> isTransient(boolean isTransient) {
        this.dataBinding.isTransient(isTransient);
        return this;
    }

    public V get() {
        Value value = (Value)this.dataBinding.get();
        Object valueObject = this.valueForm.cast((Item)value);
        if (valueObject != null) {
            return (V)valueObject;
        }
        return (V)this.valueForm.unit();
    }

    public V set(V newValueObject) {
        Value newValue = this.valueForm.mold(newValueObject).toValue();
        Value oldValue = (Value)this.dataBinding.set(newValue);
        Object oldValueObject = this.valueForm.cast((Item)oldValue);
        if (oldValueObject != null) {
            return (V)oldValueObject;
        }
        return (V)this.valueForm.unit();
    }

    public void close() {
        this.dataBinding.close();
    }

    @Override
    public void didChange() {
    }

    @Override
    public void didCommit() {
    }

    @Override
    public void didSet(Value newValue, Value oldValue) {
    }
}

