/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class IntegerForm
extends Form<Integer> {
    final Integer unit;

    public IntegerForm(Integer unit) {
        this.unit = unit;
    }

    @Override
    public Integer unit() {
        return this.unit;
    }

    @Override
    public Form<Integer> unit(Integer unit) {
        return new IntegerForm(unit);
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    public Item mold(Integer value) {
        if (value != null) {
            return Num.from(value);
        }
        return Item.extant();
    }

    @Override
    public Integer cast(Item item) {
        Value value = item.target();
        try {
            return value.intValue();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

