/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Value;

public final class NumberForm
extends Form<Number> {
    final Number unit;

    public NumberForm(Number unit) {
        this.unit = unit;
    }

    @Override
    public Number unit() {
        return this.unit;
    }

    @Override
    public Form<Number> unit(Number unit) {
        return new NumberForm(unit);
    }

    @Override
    public Class<Number> type() {
        return Number.class;
    }

    @Override
    public Item mold(Number value) {
        if (value != null) {
            return Num.from(value);
        }
        return Item.extant();
    }

    @Override
    public Number cast(Item item) {
        Value value = item.target();
        try {
            return value.numberValue();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }
}

