/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.uri.Uri;
import swim.uri.UriHostIPv4;
import swim.uri.UriHostIPv6;
import swim.uri.UriHostName;
import swim.uri.UriHostUndefined;
import swim.util.HashGenCacheMap;
import swim.util.Murmur3;

public abstract class UriHost
implements Comparable<UriHost>,
Debug,
Display {
    private static UriHost undefined;
    private static HashGenCacheMap<String, UriHost> cache;

    protected UriHost() {
    }

    public boolean isDefined() {
        return true;
    }

    public abstract String address();

    public String name() {
        return null;
    }

    public String ipv4() {
        return null;
    }

    public String ipv6() {
        return null;
    }

    public InetAddress inetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.address());
    }

    @Override
    public final int compareTo(UriHost that) {
        return this.toString().compareTo(that.toString());
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UriHost) {
            return this.toString().equals(((UriHost)other).toString());
        }
        return false;
    }

    public final int hashCode() {
        return Murmur3.seed((String)this.toString());
    }

    public abstract void debug(Output<?> var1);

    public abstract void display(Output<?> var1);

    public abstract String toString();

    public static UriHost undefined() {
        if (undefined == null) {
            undefined = new UriHostUndefined();
        }
        return undefined;
    }

    public static UriHost name(String address) {
        if (address == null) {
            throw new NullPointerException();
        }
        HashGenCacheMap<String, UriHost> cache = UriHost.cache();
        UriHost host = (UriHost)cache.get((Object)address);
        if (host instanceof UriHostName) {
            return host;
        }
        return (UriHost)cache.put((Object)address, (Object)new UriHostName(address));
    }

    public static UriHost ipv4(String address) {
        if (address == null) {
            throw new NullPointerException();
        }
        HashGenCacheMap<String, UriHost> cache = UriHost.cache();
        UriHost host = (UriHost)cache.get((Object)address);
        if (host instanceof UriHostIPv4) {
            return host;
        }
        return (UriHost)cache.put((Object)address, (Object)new UriHostIPv4(address));
    }

    public static UriHost ipv6(String address) {
        if (address == null) {
            throw new NullPointerException();
        }
        HashGenCacheMap<String, UriHost> cache = UriHost.cache();
        UriHost host = (UriHost)cache.get((Object)address);
        if (host instanceof UriHostIPv6) {
            return host;
        }
        return (UriHost)cache.put((Object)address, (Object)new UriHostIPv6(address));
    }

    public static UriHost inetAddress(InetAddress address) {
        if (address == null) {
            throw new NullPointerException();
        }
        if (address instanceof Inet4Address) {
            return UriHost.ipv4(address.getHostAddress());
        }
        if (address instanceof Inet6Address) {
            return UriHost.ipv6(address.getHostAddress());
        }
        return UriHost.name(address.getHostName());
    }

    public static UriHost parse(String string) {
        return Uri.standardParser().parseHostString(string);
    }

    static HashGenCacheMap<String, UriHost> cache() {
        if (cache == null) {
            int cacheSize;
            try {
                cacheSize = Integer.parseInt(System.getProperty("swim.uri.host.cache.size"));
            }
            catch (NumberFormatException e) {
                cacheSize = 16;
            }
            cache = new HashGenCacheMap(cacheSize);
        }
        return cache;
    }
}

