/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.collections.HashTrieMap;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;
import swim.uri.UriPathPattern;
import swim.uri.UriQuery;
import swim.uri.UriScheme;

final class UriPathVariable
extends UriPathPattern {
    final String name;
    final UriPathPattern rest;

    UriPathVariable(String name, UriPathPattern rest) {
        this.name = name;
        this.rest = rest;
    }

    @Override
    public Uri toUri() {
        return this.rest.toUri();
    }

    @Override
    Uri apply(UriScheme scheme, UriAuthority authority, UriPathBuilder path, String[] args, int index) {
        path.add(args[index]);
        return this.rest.apply(scheme, authority, path, args, index + 1);
    }

    @Override
    HashTrieMap<String, String> unapply(UriPath path, UriQuery query, UriFragment fragment, HashTrieMap<String, String> args) {
        if (!path.isEmpty()) {
            return this.rest.unapply(path.tail(), query, fragment, (HashTrieMap<String, String>)args.updated((Object)this.name, (Object)path.head()));
        }
        return args;
    }

    @Override
    boolean matches(UriPath path, UriQuery query, UriFragment fragment) {
        if (!path.isEmpty()) {
            return this.rest.matches(path.tail(), query, fragment);
        }
        return false;
    }
}

