/*
 * Decompiled with CFR 0.152.
 */
package swim.vm;

import java.util.Collection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import swim.dynamic.Bridge;
import swim.dynamic.GuestWrapper;
import swim.dynamic.HostArrayType;
import swim.dynamic.HostLibrary;
import swim.dynamic.HostMethod;
import swim.dynamic.HostObjectType;
import swim.dynamic.HostPackage;
import swim.dynamic.HostRuntime;
import swim.dynamic.HostStaticMethod;
import swim.dynamic.HostType;
import swim.dynamic.HostValue;
import swim.vm.VmBridgeArray;
import swim.vm.VmHostArray;
import swim.vm.VmHostMethod;
import swim.vm.VmHostObject;
import swim.vm.VmHostProxy;
import swim.vm.VmHostStaticMethod;

public class VmBridge
extends Bridge {
    final HostRuntime hostRuntime;
    String guestLanguage;

    public VmBridge(HostRuntime hostRuntime, String guestLanguage) {
        this.hostRuntime = hostRuntime;
        this.guestLanguage = guestLanguage;
    }

    public final HostRuntime hostRuntime() {
        return this.hostRuntime;
    }

    public final String guestLanguage() {
        return this.guestLanguage;
    }

    protected void setGuestLanguage(String guestLanguage) {
        this.guestLanguage = guestLanguage;
    }

    public HostLibrary getHostLibrary(String libraryName) {
        return this.hostRuntime.getHostLibrary(libraryName);
    }

    public Collection<HostLibrary> hostLibraries() {
        return this.hostRuntime.hostLibraries();
    }

    public HostPackage getHostPackage(String packageName) {
        return this.hostRuntime.getHostPackage(packageName);
    }

    public Collection<HostPackage> hostPackages() {
        return this.hostRuntime.hostPackages();
    }

    public HostType<?> getHostType(Class<?> typeClass) {
        return this.hostRuntime.getHostType(typeClass);
    }

    public Collection<HostType<?>> hostTypes() {
        return this.hostRuntime.hostTypes();
    }

    public boolean isNativeHostClass(Class<?> hostClass) {
        return hostClass.isPrimitive() || hostClass == Object.class || hostClass == String.class || hostClass == Boolean.class || hostClass == Byte.class || hostClass == Character.class || hostClass == Short.class || hostClass == Integer.class || hostClass == Long.class || hostClass == Float.class || hostClass == Double.class;
    }

    public final <T> HostType<? super T> hostType(T hostValue) {
        Class<?> hostClass;
        if (hostValue instanceof HostValue) {
            return ((HostValue)hostValue).dynamicType();
        }
        if (hostValue != null && !(hostClass = hostValue.getClass()).isArray() && !this.isNativeHostClass(hostClass)) {
            do {
                HostType<?> hostType;
                if ((hostType = this.getHostType(hostClass)) == null || hostType.isBuiltin()) continue;
                return hostType;
            } while ((hostClass = hostClass.getSuperclass()) != null);
            Class<?>[] interfaces = hostValue.getClass().getInterfaces();
            int n = interfaces.length;
            for (int i = 0; i < n; ++i) {
                HostType<?> hostType = this.getHostType(interfaces[i]);
                if (hostType == null || hostType.isBuiltin()) continue;
                return hostType;
            }
        }
        return null;
    }

    public <T> Object hostTypedValueToGuestProxy(HostType<? super T> hostType, T hostValue) {
        if (hostType instanceof HostObjectType) {
            return new VmHostObject<T>(this, (HostObjectType)hostType, hostValue);
        }
        if (hostType instanceof HostArrayType) {
            return new VmHostArray<T>(this, (HostArrayType)hostType, hostValue);
        }
        throw new UnsupportedOperationException();
    }

    public Object hostToGuest(Object hostValue) {
        HostType<Object> hostType;
        Object guestValue = hostValue instanceof Value || hostValue instanceof Proxy ? hostValue : (hostValue instanceof GuestWrapper ? ((GuestWrapper)hostValue).unwrap() : ((hostType = this.hostType(hostValue)) != null ? this.hostTypedValueToGuestProxy(hostType, hostValue) : (hostValue instanceof Object[] ? new VmBridgeArray(this, (Object[])hostValue) : hostValue)));
        return guestValue;
    }

    public Object guestToHost(Object guestValue) {
        Value value;
        Object hostValue = guestValue instanceof Value ? ((value = (Value)guestValue).isProxyObject() ? value.asProxyObject() : (value.isHostObject() ? value.asHostObject() : (value.isString() ? value.asString() : (value.isNumber() ? value.as(Number.class) : (value.isBoolean() ? Boolean.valueOf(value.asBoolean()) : (value.isNull() ? null : guestValue)))))) : guestValue;
        if (hostValue instanceof VmHostProxy) {
            hostValue = ((VmHostProxy)hostValue).unwrap();
        }
        return hostValue;
    }

    public <T> Object hostMethodToGuestMethod(HostMethod<? super T> method, T self) {
        return new VmHostMethod<T>(this, method, self);
    }

    public Object hostStaticMethodToGuestStaticMethod(HostStaticMethod staticMethod) {
        return new VmHostStaticMethod(this, staticMethod);
    }

    public boolean guestCanExecute(Object guestFunction) {
        return guestFunction instanceof Value && ((Value)guestFunction).canExecute();
    }

    public Object guestExecute(Object guestFunction, Object ... hostArguments) {
        if (guestFunction instanceof Value) {
            int arity = hostArguments.length;
            Object[] guestArguments = new Object[arity];
            for (int i = 0; i < arity; ++i) {
                guestArguments[i] = this.hostToGuest(hostArguments[i]);
            }
            Value guestResult = ((Value)guestFunction).execute(guestArguments);
            Object hostResult = this.guestToHost(guestResult);
            return hostResult;
        }
        throw new UnsupportedOperationException();
    }

    public void guestExecuteVoid(Object guestFunction, Object ... hostArguments) {
        Object[] guestArguments;
        if (guestFunction instanceof Value) {
            int arity = hostArguments.length;
            guestArguments = new Object[arity];
            for (int i = 0; i < arity; ++i) {
                guestArguments[i] = this.hostToGuest(hostArguments[i]);
            }
        } else {
            throw new UnsupportedOperationException();
        }
        ((Value)guestFunction).executeVoid(guestArguments);
    }

    public boolean guestCanInvokeMember(Object guestObject, String member) {
        return guestObject instanceof Value && ((Value)guestObject).canInvokeMember(member);
    }

    public Object guestInvokeMember(Object guestObject, String member, Object ... hostArguments) {
        if (guestObject instanceof Value) {
            int arity = hostArguments.length;
            Object[] guestArguments = new Object[arity];
            for (int i = 0; i < arity; ++i) {
                guestArguments[i] = this.hostToGuest(hostArguments[i]);
            }
            Value guestResult = ((Value)guestObject).invokeMember(member, guestArguments);
            Object hostResult = this.guestToHost(guestResult);
            return hostResult;
        }
        throw new UnsupportedOperationException();
    }
}

