package ai.vyro.imagine.sdk.features.inpaint

import ai.vyro.imagine.sdk.models.Response
import ai.vyro.imagine.sdk.models.ResponseImpl
import ai.vyro.imagine.sdk.models.response.Image
import ai.vyro.imagine.sdk.models.response.ImageImpl
import ai.vyro.imagine.sdk.models.response.Status
import ai.vyro.imagine.sdk.remote.post
import ai.vyro.imagine.sdk.request.filesOf
import ai.vyro.imagine.sdk.request.parametersOf
import io.ktor.client.HttpClient

private const val ENDPOINT = "edits/inpaint"

class InPaintHandler(
    private val client: HttpClient,
) {
    suspend operator fun invoke(
        imageBytes: ByteArray,
        maskBytes: ByteArray,
        prompt: String,
        modelVersion: Int,
    ): Response<Image> {
        val (code, data) = client.post(
            endpoint = ENDPOINT,
            body = parametersOf(
                "prompt" to prompt,
                "model_version" to modelVersion
            ),
            files = filesOf(
                "image" to imageBytes,
                "mask" to maskBytes
            )
        )

        if (code != 200) {
            return ResponseImpl(null, Status.fromInt(code), data.decodeToString())
        }

        return ResponseImpl(ImageImpl(data), Status.fromInt(code), null)
    }
}