package ai.vyro.imagine.sdk.features.upscale

import ai.vyro.imagine.sdk.models.Response
import ai.vyro.imagine.sdk.models.ResponseImpl
import ai.vyro.imagine.sdk.models.response.Image
import ai.vyro.imagine.sdk.models.response.ImageImpl
import ai.vyro.imagine.sdk.models.response.Status
import ai.vyro.imagine.sdk.remote.post
import ai.vyro.imagine.sdk.request.filesOf
import ai.vyro.imagine.sdk.request.parametersOf
import io.ktor.client.HttpClient

private const val ENDPOINT: String = "upscale/"

class UpscaleHandler(
    private val client: HttpClient,
) {
    suspend operator fun invoke(
        imageBytes: ByteArray,
        modelVersion: Int,
    ): Response<Image> {
        val (code, data) = client.post(
            endpoint = ENDPOINT,
            body = parametersOf(
                "model_version" to modelVersion
            ),
            files = filesOf(
                "image" to imageBytes
            )
        )

        if (code != 200) {
            return ResponseImpl(null, Status.fromInt(code), data.decodeToString())
        }

        return ResponseImpl(ImageImpl(data), Status.fromInt(code), null)
    }
}