package ai.vyro.imagine.sdk.models.response

internal data class Data(
    val code: Int,
    val payload: ByteArray
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Data

        if (code != other.code) return false
        if (!payload.contentEquals(other.payload)) return false

        return true
    }

    override fun hashCode(): Int {
        var result = code
        result = 31 * result + payload.contentHashCode()
        return result
    }
}