package ai.vyro.imagine.sdk.models.response

enum class Status(val code: Int) {
    OK(200),
    BAD_REQUEST(400),
    UNAUTHORIZED(401),
    NOT_ENOUGH_CREDITS(402),
    NOT_FOUND(404),
    UNPROCESSABLE_ENTITY(422),
    TOO_MANY_REQUESTS(429),
    INTERNAL_SERVER_ERROR(500),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504);

    companion object {
        fun fromInt(code: Int) = Status.values().firstOrNull {
            it.code == code
        } ?: throw IllegalArgumentException("Invalid Status: $code")
    }
}