package ai.vyro.imagine

import ai.vyro.imagine.sdk.Imagine
import ai.vyro.imagine.sdk.features.AspectRatio
import ai.vyro.imagine.sdk.features.generations.GenerationsStyle
import ai.vyro.imagine.sdk.features.inpaint.InPaintStyle
import ai.vyro.imagine.sdk.features.remix.ImageRemixControl
import ai.vyro.imagine.sdk.features.remix.ImageRemixStyle
import ai.vyro.imagine.sdk.features.upscale.UpscaleStyle
import ai.vyro.imagine.sdk.models.Response
import ai.vyro.imagine.sdk.models.response.Image
import platform.Foundation.NSData


typealias AsyncResponse<T> = SuspendWrapper<Response<T>>
@Suppress("unused")
class ImagineAsyncClient(
    private val client: Imagine
) {
    fun generations(
        prompt: String,
        style: GenerationsStyle,
        aspectRatio: AspectRatio? = null,
        negPrompt: String? = null,
        cfg: Float? = null,
        seed: Int? = null,
        steps: Int? = null,
        highResResults: Boolean = false
    ): AsyncResponse<Image> = suspend {
        client.generations(
            prompt = prompt,
            style = style,
            aspectRatio = aspectRatio,
            negPrompt = negPrompt,
            cfg = cfg,
            seed = seed,
            steps = steps,
            highResolution = highResResults
        )
    }.wrap()

    fun remix(
        image: NSData,
        prompt: String,
        style: ImageRemixStyle,
        control: ImageRemixControl,
        negPrompt: String? = null,
        cfg: Float? = null,
        seed: Int? = null,
        steps: Int? = null,
        strength: Int? = null
    ): AsyncResponse<Image> = suspend {
        client.remix(
            image = image.toByteArray(),
            prompt = prompt,
            style = style,
            control = control,
            negPrompt = negPrompt,
            cfg = cfg,
            seed = seed,
            steps = steps,
            strength = strength
        )
    }.wrap()

    fun upscale(
        image: NSData,
        style: UpscaleStyle
    ): AsyncResponse<Image> = suspend {
        client.upscale(
            image = image.toByteArray(),
            style = style
        )
    }.wrap()

    fun variations(
        image: NSData,
        prompt: String,
        style: GenerationsStyle = GenerationsStyle.IMAGINE_V5,
        negPrompt: String? = null,
        cfg: Float? = null,
        seed: Int? = null,
        steps: Int? = null,
        strength: Int? = null
    ): AsyncResponse<Image> = suspend {
        client.variations(
            image = image.toByteArray(),
            prompt = prompt,
            style = style,
            negPrompt = negPrompt,
            cfg = cfg,
            seed = seed,
            steps = steps,
            strength = strength
        )
    }.wrap()

    fun inpaint(
        image: NSData,
        mask: NSData,
        prompt: String,
        style: InPaintStyle = InPaintStyle.BASIC
    ): AsyncResponse<Image> = suspend {
        client.inpaint(
            image = image.toByteArray(),
            mask = mask.toByteArray(),
            prompt = prompt,
            style = style
        )
    }.wrap()
}

