package ai.vyro.imagine

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.CoroutineStart
import kotlinx.coroutines.Job
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.async

@Suppress("unused")
class SuspendWrapper<out T> internal constructor(
    private val scope: CoroutineScope,
    private val block: suspend () -> T & Any
) {
    private var job: Job? = null
    private var isCancelled = false

    fun cancel() {
        isCancelled = true
        job?.cancel()
    }

    suspend fun run(): T & Any {
        val deferred = scope.async(start = CoroutineStart.LAZY) { block() }
        job = deferred

        if (isCancelled) deferred.cancel() else deferred.start()

        return deferred.await()
    }
}

internal fun <T : Any> (suspend () -> T).wrap(
    scope: CoroutineScope = MainScope()
): SuspendWrapper<T> {
    return SuspendWrapper(scope = scope, block = this)
}


