package ai.vyro.imagine.sdk.features.generations

import ai.vyro.imagine.sdk.models.Response
import ai.vyro.imagine.sdk.models.ResponseImpl
import ai.vyro.imagine.sdk.models.response.Image
import ai.vyro.imagine.sdk.models.response.ImageImpl
import ai.vyro.imagine.sdk.models.response.Status
import ai.vyro.imagine.sdk.remote.post
import ai.vyro.imagine.sdk.request.parametersOf
import io.ktor.client.HttpClient

private const val ENDPOINT: String = "generations"

class GenerationsHandler(
    private val client: HttpClient,
) {
    suspend operator fun invoke(
        prompt: String,
        style: Int,
        negPrompt: String? = null,
        cfg: Float? = null,
        seed: Int? = null,
        steps: Int? = null,
        aspectRatio: String? = null,
        highResResults: Int? = null,
    ): Response<Image> {
        val (code, data) = client.post(
            endpoint = ENDPOINT,
            body = parametersOf(
                "prompt" to prompt,
                "style_id" to style,
                "aspect_ratio" to aspectRatio,
                "negative_prompt" to negPrompt,
                "cfg" to cfg,
                "seed" to seed,
                "steps" to steps,
                "high_res_results" to highResResults
            )
        )

        if (code != 200) {
            return ResponseImpl(null, Status.fromInt(code), data.decodeToString())
        }

        return ResponseImpl(ImageImpl(data), Status.fromInt(code), null)
    }
}