package ai.vyro.imagine.sdk.models

import ai.vyro.imagine.sdk.models.response.Status

abstract class Response<out T> {
    abstract val status: Status
    abstract val data: T?
    abstract val message: String?
}

@Suppress("unused")
@Throws(IllegalStateException::class)
fun <T> Response<T>.getOrThrow(): T =
    data ?: throw IllegalStateException("Status:$status  Message:$message")

@Suppress("unused")
fun <T> Response<T>.getOrElse(value: T): T = data ?: value

internal class ResponseImpl<T>(
    override val data: T?,
    override val status: Status,
    override val message: String?
) : Response<T>()