package ai.vyro.imagine.sdk.plugins

import io.ktor.client.HttpClientConfig

interface ImagineConfig {
    fun ktor(config: HttpClientConfig<*>.() -> Unit)
    fun <T : ImaginePlugin> install(plugin: T, block: T.() -> Unit = {})
}

internal class ConfigImpl : ImagineConfig {
    private var ktorConfig: HttpClientConfig<*>.() -> Unit = {}
    private val plugins = mutableSetOf<ImaginePlugin>(Timeout)

    override fun ktor(config: HttpClientConfig<*>.() -> Unit) {
        ktorConfig = config
    }

    override fun <T : ImaginePlugin> install(plugin: T, block: T.() -> Unit) {
        plugins.add(plugin.apply(block))
    }

    fun build(): (HttpClientConfig<*>) -> Unit {
        return {
            it.ktorConfig()
            for (plugin in plugins) {
                with(plugin) {
                    it.ktorInternal()
                }
            }
        }
    }
}
