package ai.vyro.imagine.sdk.plugins

import io.ktor.client.HttpClientConfig
import io.ktor.client.plugins.HttpTimeout

object Timeout : ImaginePlugin() {
    private var time: Long = 180000

    fun timeout(t: Long) {
        time = t
    }

    override fun HttpClientConfig<*>.configure() {
        install(HttpTimeout) {
            requestTimeoutMillis = time
        }
    }
}