package ai.vyro.imagine

import ai.vyro.imagine.sdk.plugins.ImagineConfig
import ai.vyro.imagine.sdk.plugins.ImaginePlugin

@Suppress("unused")
class ConfigBuilder {
    private val plugins = mutableListOf<ImaginePlugin>()

    fun install(plugin: ImaginePlugin): ConfigBuilder = apply {
        plugins.add(plugin)
    }

    fun build(): ImagineConfig.() -> Unit {
        return {
            for (plugin in plugins) {
                install(plugin)
            }
        }
    }
}
