package ai.vyro.imagine

import ai.vyro.imagine.sdk.models.response.Image
import kotlinx.cinterop.BetaInteropApi
import kotlinx.cinterop.ExperimentalForeignApi
import kotlinx.cinterop.addressOf
import kotlinx.cinterop.allocArrayOf
import kotlinx.cinterop.memScoped
import kotlinx.cinterop.usePinned
import platform.Foundation.NSData
import platform.Foundation.NSFileHandle
import platform.Foundation.create
import platform.Foundation.dataWithContentsOfFile
import platform.Foundation.writeToFile
import platform.UIKit.UIImage
import platform.posix.memcpy

@OptIn(ExperimentalForeignApi::class, BetaInteropApi::class)
fun ByteArray.toNSData(): NSData = memScoped {
    val data = this@toNSData
    NSData.create(
        bytes = allocArrayOf(data),
        length = data.size.toULong()
    )
}

@OptIn(ExperimentalForeignApi::class)
fun NSData.toByteArray(): ByteArray = ByteArray(length.toInt()).also { array ->
    array.usePinned {
        memcpy(it.addressOf(0), bytes, length)
    }
}

@Suppress("unused")
fun NSFileHandle.readFile(): ByteArray = availableData.toByteArray()

@Suppress("unused")
fun String.readFromPath(): NSData = NSData.dataWithContentsOfFile(this) ?: NSData()

@Suppress("unused")
fun Image.toUIImage(): UIImage = UIImage(bytes.toNSData())

@Suppress("unused")
fun Image.asFile(path: String): Boolean = bytes.toNSData().writeToFile(path, true)