/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.resources;

import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.services.ResourcesService;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="expose", description={"Expose resources"})
public class ResourcesExpose
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Option(names={"--location"}, description={"The of the resource"}, required=true, arity="0..1")
    private String location;
    @CommandLine.Option(names={"--type"}, description={"The type of the resource"}, required=true, arity="0..1")
    private String type;
    @CommandLine.Option(names={"--name"}, description={"A human-readable name for the resource"}, required=true, arity="0..1")
    private String name;
    @CommandLine.Option(names={"--description"}, description={"A brief description of the resource"}, required=true, arity="0..1")
    private String description;
    @CommandLine.Option(names={"--mimeType"}, description={"The MIME type of the resource (i.e.: text/plain)"}, required=true, defaultValue="text/plain", arity="0..1")
    private String mimeType;
    @CommandLine.Option(names={"--param"}, description={"One or more parameters for the resource"}, arity="0..n")
    private List<String> params;
    ResourcesService resourcesService;

    @Override
    public void run() {
        this.resourcesService = (ResourcesService)QuarkusRestClientBuilder.newBuilder().baseUri(URI.create(this.host)).build(ResourcesService.class);
        ResourceReference resource = new ResourceReference();
        resource.setLocation(this.location);
        resource.setType(this.type);
        resource.setName(this.name);
        resource.setDescription(this.description);
        resource.setMimeType(this.mimeType);
        if (this.params != null) {
            ArrayList<ResourceReference.Param> paramsList = new ArrayList<ResourceReference.Param>();
            for (String paramStr : this.params) {
                ResourceReference.Param param = new ResourceReference.Param();
                String[] split = paramStr.split("=");
                param.setName(split[0]);
                if (split.length > 1) {
                    param.setValue(split[1]);
                }
                paramsList.add(param);
            }
            resource.setParams(paramsList);
        }
        this.resourcesService.expose(resource);
    }
}

