/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.tools;

import ai.wanaku.api.types.ToolReference;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.services.ToolsService;
import ai.wanaku.core.util.IndexHelper;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.jboss.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import a toolset"})
public class ToolsImport
extends BaseCommand {
    private static final Logger LOG = Logger.getLogger(ToolsImport.class);
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Parameters(description={"Path to the toolset"}, arity="1..1")
    private String path;
    ToolsService toolsService;

    @Override
    public void run() {
        try {
            this.toolsService = (ToolsService)QuarkusRestClientBuilder.newBuilder().baseUri(URI.create(this.host)).build(ToolsService.class);
            File indexFile = new File(this.path);
            List toolReferences = IndexHelper.loadToolsIndex((File)indexFile);
            for (ToolReference toolReference : toolReferences) {
                this.toolsService.add(toolReference);
            }
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to load tools index: %s", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

