/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.management.Service;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrettyPrinter {
    public static void printParseable(ToolReference toolReference) {
        System.out.printf("%-15s => %-15s => %-30s    %n", toolReference.getName(), toolReference.getType(), toolReference.getUri());
    }

    public static void printTools(List<ToolReference> list) {
        System.out.printf("%-15s    %-15s    %-30s    %n", "Name", "Type", "URI");
        for (ToolReference toolReference : list) {
            PrettyPrinter.printParseable(toolReference);
        }
    }

    public static void printParseable(ResourceReference resourceReference) {
        System.out.printf("%-20s => %-15s => %-30s    %s%n", resourceReference.getName(), resourceReference.getType(), resourceReference.getLocation(), resourceReference.getDescription());
    }

    public static void printResources(List<ResourceReference> list) {
        System.out.printf("%-20s    %-15s    %-30s    %s%n", "Name", "Type", "Location", "Description");
        for (ResourceReference packageInfo : list) {
            PrettyPrinter.printParseable(packageInfo);
        }
    }

    public static void printParseableTarget(String name, Service service) {
        Map configurations = service.getConfigurations().getConfigurations();
        String strings = configurations.keySet().stream().sorted().collect(Collectors.joining(", "));
        System.out.printf("%-20s => %-30s => %-30s%n", name, service.getTarget(), strings);
    }

    public static void printTargets(Map<String, Service> map) {
        System.out.printf("%-20s    %-30s    %-30s%n", "Service", "Target", "Configurations");
        for (Map.Entry<String, Service> entry : map.entrySet()) {
            PrettyPrinter.printParseableTarget(entry.getKey(), entry.getValue());
        }
    }
}

