/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.types.ForwardReference;
import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.management.Service;
import ai.wanaku.api.types.management.State;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PrettyPrinter {
    private PrettyPrinter() {
    }

    public static void printTool(ToolReference toolReference) {
        System.out.printf("%-15s => %-15s => %-30s    %n", toolReference.getName(), toolReference.getType(), toolReference.getUri());
    }

    public static void printTools(List<ToolReference> list) {
        System.out.printf("%-15s    %-15s    %-30s    %n", "Name", "Type", "URI");
        list.forEach(PrettyPrinter::printTool);
    }

    public static void printResourceRef(ResourceReference resourceReference) {
        System.out.printf("%-20s => %-15s => %-30s    %s%n", resourceReference.getName(), resourceReference.getType(), resourceReference.getLocation(), resourceReference.getDescription());
    }

    public static void printResources(List<ResourceReference> list) {
        System.out.printf("%-20s    %-15s    %-30s    %s%n", "Name", "Type", "Location", "Description");
        list.forEach(PrettyPrinter::printResourceRef);
    }

    public static void printTarget(String name, Service service) {
        Map configurations = service.getConfigurations().getConfigurations();
        String strings = configurations.keySet().stream().sorted().collect(Collectors.joining(", "));
        System.out.printf("%-20s => %-30s => %-30s%n", name, service.getTarget(), strings);
    }

    public static void printTargets(Map<String, Service> map) {
        System.out.printf("%-20s    %-30s    %-30s%n", "Service", "Target", "Configurations");
        map.forEach(PrettyPrinter::printTarget);
    }

    public static void printStates(Map<String, List<State>> states) {
        System.out.printf("%-20s    %-10s    %-60s%n", "Service", "Healthy", "Message");
        for (Map.Entry<String, List<State>> entry : states.entrySet()) {
            for (State state : entry.getValue()) {
                PrettyPrinter.printState(entry.getKey(), state.healthy(), state.message());
            }
        }
    }

    private static void printState(String service, boolean healthy, String message) {
        System.out.printf("%-15s => %-15s => %-30s    %n", service, healthy, message);
    }

    private static void printForwardReference(ForwardReference reference) {
        System.out.printf("%-20s    %-60s%n", reference.getName(), reference.getAddress());
    }

    public static void printForwards(List<ForwardReference> list) {
        System.out.printf("%-20s    %-60s%n", "Service", "Address");
        list.forEach(PrettyPrinter::printForwardReference);
    }
}

