/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.start;

import ai.wanaku.api.exceptions.WanakuException;
import ai.wanaku.cli.main.commands.start.StartBase;
import ai.wanaku.cli.main.support.RuntimeConstants;
import ai.wanaku.cli.main.support.WanakuCliConfig;
import ai.wanaku.cli.runner.local.LocalRunner;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="local", description={"Create a new tool service"})
public class StartLocal
extends StartBase {
    private static final Logger LOG = Logger.getLogger(StartLocal.class);
    @Inject
    WanakuCliConfig config;

    @Override
    protected void startWanaku() {
        List<String> services = this.exclusive != null && this.exclusive.services != null ? this.exclusive.services : this.config.defaultServices();
        LocalRunner localRunner = new LocalRunner(this.config);
        try {
            localRunner.start(services);
        }
        catch (WanakuException | IOException e) {
            LOG.errorf(e, e.getMessage(), new Object[0]);
        }
    }

    public static void deleteDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (String child : Objects.requireNonNull(children)) {
                File childDir = new File(dir, child);
                StartLocal.deleteDirectory(childDir);
            }
        }
        if (!dir.delete()) {
            System.err.println("Failed to delete " + String.valueOf(dir));
        }
    }

    @Override
    public void run() {
        if (this.exclusive != null && this.exclusive.exclusiveNonStart != null) {
            if (this.exclusive.exclusiveNonStart.listServices) {
                Map<String, String> components = this.config.components();
                for (String component : components.keySet()) {
                    if (component.equals("wanaku-router")) continue;
                    System.out.println(" - " + component);
                }
                return;
            }
            if (this.exclusive.exclusiveNonStart.clean) {
                System.out.println("Removing Wanaku cache directory");
                StartLocal.deleteDirectory(new File(RuntimeConstants.WANAKU_CACHE_DIR));
                System.out.println("Removing Wanaku local instance directory");
                StartLocal.deleteDirectory(new File(RuntimeConstants.WANAKU_LOCAL_DIR));
                return;
            }
        }
        this.startWanaku();
    }
}

