/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.logging.Logger;

public class ZipHelper {
    private static final Logger LOG = Logger.getLogger(ZipHelper.class);

    public static void unzip(File zipFilePath, String destination, String componentName) throws IOException {
        ZipHelper.unzip(zipFilePath, new File(destination), componentName);
    }

    public static void unzip(File zipFilePath, File destination, String componentName) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                LOG.debugf("Unpacking %s", (Object)entry.getName());
                String name = ZipHelper.finalEntryName(componentName, entry);
                File unzippedFile = new File(destination, name);
                if (!entry.isDirectory()) {
                    try (InputStream in = zipFile.getInputStream(entry);){
                        try (FileOutputStream out = new FileOutputStream(unzippedFile);){
                            in.transferTo(out);
                        }
                        catch (IOException e) {
                            LOG.errorf((Throwable)e, "Error writing to file: %s", (Object)e.getMessage());
                        }
                    }
                    catch (IOException e) {
                        LOG.errorf((Throwable)e, "Error reading from entry: %s", (Object)e.getMessage());
                    }
                    continue;
                }
                if (unzippedFile.exists()) {
                    return;
                }
                Files.createDirectories(unzippedFile.toPath(), new FileAttribute[0]);
            }
        }
        LOG.infof("ZIP file contents extracted successfully to: %s", (Object)destination.getAbsolutePath());
    }

    private static String finalEntryName(String componentName, ZipEntry entry) {
        int idx = entry.getName().indexOf("/");
        String entryName = entry.getName().substring(idx);
        return String.format("%s/%s", componentName, entryName);
    }
}

