/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands;

import ai.wanaku.cli.main.support.WanakuPrinter;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import java.net.URI;
import java.util.concurrent.Callable;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

public abstract class BaseCommand
implements Callable<Integer> {
    public static final int EXIT_OK = 0;
    public static final int EXIT_ERROR = 1;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display the help and sub-commands"})
    private boolean helpRequested = false;

    protected static <T> T initService(Class<T> clazz, String host) {
        if (host == null) {
            throw new NullPointerException("Host URL cannot be null");
        }
        try {
            return (T)QuarkusRestClientBuilder.newBuilder().baseUri(URI.create(host)).build(clazz);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid host URL: " + host, e);
        }
    }

    @Override
    public Integer call() throws Exception {
        try (Terminal terminal = WanakuPrinter.terminalInstance();){
            WanakuPrinter printer = new WanakuPrinter(null, terminal);
            Integer n = this.doCall(terminal, printer);
            return n;
        }
    }

    public abstract Integer doCall(Terminal var1, WanakuPrinter var2) throws Exception;
}

