/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.capabilities;

import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.CapabilitiesHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.TargetsService;
import java.io.IOException;
import java.util.List;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all available capabilities"})
public class CapabilitiesList
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host URL (default: http://localhost:8080)"}, defaultValue="http://localhost:8080")
    private String host;
    private TargetsService targetsService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws IOException, Exception {
        this.targetsService = CapabilitiesList.initService(TargetsService.class, this.host);
        List capabilities = (List)CapabilitiesHelper.fetchAndMergeCapabilities(this.targetsService).await().atMost(CapabilitiesHelper.API_TIMEOUT);
        CapabilitiesHelper.printCapabilities(capabilities, printer);
        return 0;
    }
}

