/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.capabilities;

import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.CapabilitiesHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.TargetsService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.ListPromptBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show detailed information about a specific capability"})
public class CapabilitiesShow
extends BaseCommand {
    private static final String DEFAULT_HOST = "http://localhost:8080";
    private static final String CAPABILITY_CHOICE_FORMAT = "%-20s  %-20s  %-5d  %-10s  %-45s";
    private static final String SELECTION_PROMPT_NAME = "index";
    @CommandLine.Option(names={"--host"}, description={"The API host URL (default: http://localhost:8080)"}, defaultValue="http://localhost:8080")
    private String host;
    @CommandLine.Parameters(description={"The service name to show details for (e.g., http, sqs, file)"}, arity="1..1")
    private String service;
    private TargetsService targetsService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws IOException, Exception {
        this.targetsService = CapabilitiesShow.initService(TargetsService.class, this.host);
        List<CapabilitiesHelper.PrintableCapability> capabilities = ((List)CapabilitiesHelper.fetchAndMergeCapabilities(this.targetsService).await().atMost(CapabilitiesHelper.API_TIMEOUT)).stream().filter(capability -> capability.service().equals(this.service)).toList();
        return switch (capabilities.size()) {
            case 0 -> this.handleNoCapabilities(printer);
            case 1 -> this.handleSingleCapability(printer, capabilities.getFirst());
            default -> this.handleMultipleCapabilities(terminal, printer, capabilities);
        };
    }

    private Integer handleNoCapabilities(WanakuPrinter printer) throws IOException {
        printer.printWarningMessage("No capabilities found for service: " + this.service);
        return 1;
    }

    private Integer handleSingleCapability(WanakuPrinter printer, CapabilitiesHelper.PrintableCapability capability) throws Exception {
        this.printCapabilityDetails(printer, capability);
        return 0;
    }

    private Integer handleMultipleCapabilities(Terminal terminal, WanakuPrinter printer, List<CapabilitiesHelper.PrintableCapability> capabilities) throws Exception {
        printer.printWarningMessage("Multiple capabilities found for the " + this.service + " service. Please choose one.");
        ConsolePrompt.UiConfig uiConfig = new ConsolePrompt.UiConfig("=> ", "[]", "[x]", "-");
        ConsolePrompt prompt = new ConsolePrompt(terminal, uiConfig);
        PromptBuilder builder = prompt.getPromptBuilder();
        ListPromptBuilder listPromptBuilder = builder.createListPrompt().name(SELECTION_PROMPT_NAME).message("Select a capability instance:");
        for (int i = 0; i < capabilities.size(); ++i) {
            CapabilitiesHelper.PrintableCapability capability = capabilities.get(i);
            String displayText = this.formatCapabilityChoice(capability);
            listPromptBuilder.newItem(String.valueOf(i)).text(displayText).add();
        }
        listPromptBuilder.addPrompt();
        try {
            Map result = prompt.prompt(builder.build());
            int selectedIndex = Integer.parseInt(((PromptResultItemIF)result.get(SELECTION_PROMPT_NAME)).getResult());
            this.printCapabilityDetails(printer, capabilities.get(selectedIndex));
            return 0;
        }
        catch (Exception e) {
            printer.printErrorMessage("Error during capability selection: " + e.getMessage());
            return 1;
        }
    }

    private String formatCapabilityChoice(CapabilitiesHelper.PrintableCapability capability) {
        return String.format(CAPABILITY_CHOICE_FORMAT, capability.serviceType(), capability.host(), capability.port(), capability.status(), capability.lastSeen());
    }

    private void printCapabilityDetails(WanakuPrinter printer, CapabilitiesHelper.PrintableCapability capability) throws Exception {
        printer.printInfoMessage("Capability Details:");
        CapabilitiesHelper.printCapability(capability, printer);
        printer.printInfoMessage("\nConfigurations:");
        printer.printTable(capability.configurations(), "name", "description");
    }
}

