/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.forwards;

import ai.wanaku.api.types.ForwardReference;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ForwardsService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Add forward targets"})
public class ForwardsAdd
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Option(names={"--name"}, description={"The name of the service to forward"}, required=true, arity="0..1")
    protected String name;
    @CommandLine.Option(names={"--service"}, description={"The service to forward"}, required=true, arity="0..1")
    protected String service;
    @CommandLine.Option(names={"-N", "--namespace"}, description={"The namespace associated with the tool"}, defaultValue="", required=true)
    private String namespace;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws Exception {
        ForwardsService forwardsService = ForwardsAdd.initService(ForwardsService.class, this.host);
        ForwardReference reference = new ForwardReference();
        reference.setName(this.name);
        reference.setAddress(this.service);
        reference.setNamespace(this.namespace);
        try {
            Response ignored = forwardsService.addForward(reference);
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (WebApplicationException ex) {
            Response response = ex.getResponse();
            ResponseHelper.commonResponseErrorHandler(response);
            return 1;
        }
        return 0;
    }
}

