/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.forwards;

import ai.wanaku.api.types.WanakuResponse;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ForwardsService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List forward targets"})
public class ForwardsList
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws IOException, Exception {
        ForwardsService forwardsService = ForwardsList.initService(ForwardsService.class, this.host);
        try {
            WanakuResponse wanakuResponseRestResponse = forwardsService.listForwards();
            List data = (List)wanakuResponseRestResponse.data();
            printer.printTable(data, "name", "address");
        }
        catch (WebApplicationException ex) {
            Response response = ex.getResponse();
            ResponseHelper.commonResponseErrorHandler(response);
            return 1;
        }
        return 0;
    }
}

