/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.resources;

import ai.wanaku.api.types.ResourceReference;
import ai.wanaku.api.types.io.ResourcePayload;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.FileHelper;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ResourcesService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="expose", description={"Expose resources"})
public class ResourcesExpose
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Option(names={"--location"}, description={"The of the resource"}, required=true, arity="0..1")
    private String location;
    @CommandLine.Option(names={"--type"}, description={"The type of the resource"}, required=true, arity="0..1")
    private String type;
    @CommandLine.Option(names={"--name"}, description={"A human-readable name for the resource"}, required=true, arity="0..1")
    private String name;
    @CommandLine.Option(names={"-N", "--namespace"}, description={"The namespace associated with the tool"}, defaultValue="", required=true)
    private String namespace;
    @CommandLine.Option(names={"--description"}, description={"A brief description of the resource"}, required=true, arity="0..1")
    private String description;
    @CommandLine.Option(names={"--mimeType"}, description={"The MIME type of the resource (i.e.: text/plain)"}, required=true, defaultValue="text/plain", arity="0..1")
    private String mimeType;
    @CommandLine.Option(names={"--param"}, description={"One or more parameters for the resource"}, arity="0..n")
    private List<String> params;
    @CommandLine.Option(names={"--configuration-from-file"}, description={"Configure the capability provider using the given file"}, arity="0..1")
    private String configurationFromFile;
    @CommandLine.Option(names={"--secrets-from-file"}, description={"Add the given secrets to the capability provider using the given file"}, arity="0..1")
    private String secretsFromFile;
    ResourcesService resourcesService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws IOException, Exception {
        this.resourcesService = ResourcesExpose.initService(ResourcesService.class, this.host);
        ResourceReference resource = new ResourceReference();
        resource.setLocation(this.location);
        resource.setType(this.type);
        resource.setName(this.name);
        resource.setDescription(this.description);
        resource.setMimeType(this.mimeType);
        resource.setNamespace(this.namespace);
        ResourcePayload resourcePayload = new ResourcePayload();
        resourcePayload.setPayload(resource);
        FileHelper.loadConfigurationSources(this.configurationFromFile, arg_0 -> ((ResourcePayload)resourcePayload).setConfigurationData(arg_0));
        FileHelper.loadConfigurationSources(this.secretsFromFile, arg_0 -> ((ResourcePayload)resourcePayload).setSecretsData(arg_0));
        if (this.params != null) {
            ArrayList<ResourceReference.Param> paramsList = new ArrayList<ResourceReference.Param>();
            for (String paramStr : this.params) {
                ResourceReference.Param param = new ResourceReference.Param();
                String[] split = paramStr.split("=");
                param.setName(split[0]);
                if (split.length > 1) {
                    param.setValue(split[1]);
                }
                paramsList.add(param);
            }
            resource.setParams(paramsList);
        }
        try {
            Response response = this.resourcesService.exposeWithPayload(resourcePayload);
            if (response != null) {
                response.close();
            }
        }
        catch (WebApplicationException ex) {
            Response response = ex.getResponse();
            ResponseHelper.commonResponseErrorHandler(response);
            return 1;
        }
        return 0;
    }
}

