/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.resources;

import ai.wanaku.api.types.WanakuResponse;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ResourcesService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List resources"})
public class ResourcesList
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    ResourcesService resourcesService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws Exception {
        this.resourcesService = ResourcesList.initService(ResourcesService.class, this.host);
        try {
            WanakuResponse response = this.resourcesService.list();
            List list = (List)response.data();
            printer.printTable(list, "name", "type", "description", "location");
        }
        catch (WebApplicationException ex) {
            Response response = ex.getResponse();
            ResponseHelper.commonResponseErrorHandler(response);
            return 1;
        }
        return 0;
    }
}

