/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.resources;

import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ResourcesService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="remove", description={"Remove exposed resources"})
public class ResourcesRemove
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Option(names={"--name"}, description={"A human-readable name for the resource"}, required=true, arity="0..1")
    private String name;
    ResourcesService resourcesService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws Exception {
        this.resourcesService = ResourcesRemove.initService(ResourcesService.class, this.host);
        try (Response response = this.resourcesService.remove(this.name);){
            printer.printSuccessMessage("Successfully removed resource reference '" + this.name + "'");
        }
        catch (WebApplicationException ex) {
            Response response2 = ex.getResponse();
            if (response2.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                String warningMessage = String.format("Resource not found (%s): %s%n", this.name, response2.getStatusInfo().getReasonPhrase());
                printer.printWarningMessage(warningMessage);
            } else {
                ResponseHelper.commonResponseErrorHandler(response2);
            }
            return 1;
        }
        return 0;
    }
}

