/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.tools;

import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.WanakuResponse;
import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ToolsService;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.ListPromptBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="edit", description={"edit tool"})
public class ToolsEdit
extends BaseCommand {
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Parameters(description={"Tool name that you want to edit"}, arity="0..1")
    private String toolName;
    ToolsService toolsService;
    private static final String TEMP_FILE_PREFIX = "wanaku_edit";
    private static final String TEMP_FILE_SUFFIX = ".json";
    private static final String NANO_CONFIG_FILE = "/nano/jnanorc";
    ObjectMapper mapper = new ObjectMapper();

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws IOException, Exception {
        boolean wasModified;
        ToolReference tool;
        this.toolsService = ToolsEdit.initService(ToolsService.class, this.host);
        List list = (List)this.toolsService.list().data();
        if (list == null || list.isEmpty()) {
            System.out.println("No tools registered yet");
            return 1;
        }
        if (this.toolName == null) {
            tool = this.selectTool(terminal, list);
        } else {
            try {
                WanakuResponse response = this.toolsService.getByName(this.toolName);
                tool = (ToolReference)response.data();
            }
            catch (RuntimeException e) {
                System.err.println("Error retrieving the tool '" + this.toolName + "': " + e.getMessage());
                return 1;
            }
        }
        String toolString = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tool);
        String modifiedContent = this.edit(terminal, toolString, tool.getName());
        boolean bl = wasModified = !toolString.equals(modifiedContent);
        if (!wasModified) {
            printer.printWarningMessage("No changes detected!");
            return 0;
        }
        boolean save = this.confirm(terminal, tool);
        if (save) {
            System.out.print("saving '" + tool.getName() + "' tool...");
            ToolReference toolModified = (ToolReference)this.mapper.readValue(modifiedContent, ToolReference.class);
            toolModified.setId(tool.getId());
            Response response = this.toolsService.update(toolModified);
            if (response.getStatus() != HttpResponseStatus.OK.code()) {
                System.err.println("error!");
            }
            System.out.println("done");
        }
        return 0;
    }

    public boolean confirm(Terminal terminal, ToolReference tool) throws IOException {
        ConsolePrompt prompt = new ConsolePrompt(terminal);
        PromptBuilder builder = prompt.getPromptBuilder();
        builder.createConfirmPromp().name("continue").message("Do you want to update the '" + tool.getName() + "' tool?").defaultValue(ConfirmChoice.ConfirmationValue.NO).addPrompt();
        Map result = prompt.prompt(builder.build());
        return "YES".equalsIgnoreCase(((PromptResultItemIF)result.get("continue")).getResult());
    }

    public String edit(Terminal terminal, String toolString, String toolName) throws IOException {
        Path tempFile = Files.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX, new FileAttribute[0]);
        ConfigurationPath configPath = ConfigurationPath.fromClasspath((String)NANO_CONFIG_FILE);
        Path root = tempFile.getParent();
        Files.write(tempFile, toolString.getBytes(), new OpenOption[0]);
        Options options = Options.compile((String[])Nano.usage()).parse((Object[])new String[0]);
        Nano nano = new Nano(terminal, root, options, configPath);
        nano.title = "Edit Tool " + toolName;
        nano.mouseSupport = true;
        nano.matchBrackets = "(<[{)>]}";
        nano.printLineNumbers = true;
        nano.open(new String[]{tempFile.toAbsolutePath().toString()});
        nano.run();
        return Files.readString(tempFile);
    }

    public ToolReference selectTool(Terminal terminal, List<ToolReference> list) throws IOException {
        ConsolePrompt.UiConfig uiConfig = new ConsolePrompt.UiConfig("=> ", "[]", "[x]", "-");
        ConsolePrompt prompt = new ConsolePrompt(terminal, uiConfig);
        PromptBuilder builder = prompt.getPromptBuilder();
        ListPromptBuilder lpb = builder.createListPrompt().name("tool").message("Choose the tool you want to edit:").pageSize(5);
        List<Item> items = this.formatTable(list);
        items.stream().forEach(x -> lpb.newItem().text(x.text).name(x.id).add());
        lpb.addPrompt();
        Map result = prompt.prompt(builder.build());
        String toolId = ((PromptResultItemIF)result.get("tool")).getResult();
        ToolReference tool = list.stream().filter(x -> x.getId().equals(toolId)).findFirst().orElse(null);
        return tool;
    }

    private List<Item> formatTable(List<ToolReference> list) {
        int MAX_DESCRIPTION_DISPLAY_LENGTH = 60;
        int COLUMN_PADDING = 3;
        String TRUNCATE_INDICATOR = "...";
        int maxNameLength = list.stream().mapToInt(item -> item.getName().length()).max().orElse(0);
        int maxDescriptionDisplayLength = list.stream().mapToInt(item -> Math.min(item.getDescription().length(), 60)).max().orElse(0);
        int nameColumnWidth = Math.max(maxNameLength + 3, "Name".length() + 3);
        int descriptionColumnWidth = Math.max(maxDescriptionDisplayLength + 3, "Description".length() + 3);
        return list.stream().map(item -> {
            String name = item.getName();
            Object description = item.getDescription();
            if (((String)description).length() > 60) {
                int truncateTo = 60 - "...".length();
                description = ((String)description).substring(0, truncateTo) + "...";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ps.printf("%-" + nameColumnWidth + "s %-" + descriptionColumnWidth + "s%n", name, description);
            return new Item(item.getId(), baos.toString());
        }).toList();
    }

    private record Item(String id, String text) {
    }
}

