/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.commands.tools;

import ai.wanaku.cli.main.commands.BaseCommand;
import ai.wanaku.cli.main.converter.URLConverter;
import ai.wanaku.cli.main.support.ToolHelper;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.ToolsService;
import ai.wanaku.core.util.ToolsetIndexHelper;
import java.net.URL;
import java.util.List;
import org.jboss.logging.Logger;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

@CommandLine.Command(name="import", description={"Import a toolset"})
public class ToolsImport
extends BaseCommand {
    private static final Logger LOG = Logger.getLogger(ToolsImport.class);
    @CommandLine.Option(names={"--host"}, description={"The API host"}, defaultValue="http://localhost:8080", arity="0..1")
    protected String host;
    @CommandLine.Parameters(description={"location to the toolset, can be a local path or an URL"}, arity="1..1", converter={URLConverter.class})
    private URL location;
    ToolsService toolsService;

    @Override
    public Integer doCall(Terminal terminal, WanakuPrinter printer) throws Exception {
        try {
            List toolReferences = ToolsetIndexHelper.loadToolsIndex((URL)this.location);
            ToolHelper.importToolset(toolReferences, this.host);
        }
        catch (Exception e) {
            printer.printErrorMessage(String.format("Failed to load tools index: %s", e.getMessage()));
            throw new RuntimeException(e);
        }
        return 0;
    }
}

