/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.exceptions.WanakuException;
import ai.wanaku.api.types.WanakuResponse;
import ai.wanaku.api.types.discovery.ActivityRecord;
import ai.wanaku.api.types.providers.ServiceTarget;
import ai.wanaku.api.types.providers.ServiceType;
import ai.wanaku.cli.main.support.WanakuPrinter;
import ai.wanaku.core.services.api.TargetsService;
import io.quarkus.runtime.annotations.RegisterForReflection;
import io.smallrye.mutiny.Uni;
import java.time.Duration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CapabilitiesHelper {
    public static final Duration API_TIMEOUT = Duration.ofSeconds(15L);
    public static final String DEFAULT_STATUS = "-";
    public static final String ACTIVE_STATUS = "active";
    public static final String INACTIVE_STATUS = "inactive";
    public static final DateTimeFormatter VERBOSE_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("EEE, MMM dd, yyyy 'at' HH:mm:ss");
    public static final String[] COLUMNS = new String[]{"service", "serviceType", "host", "port", "status", "lastSeen"};

    private CapabilitiesHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Uni<List<PrintableCapability>> fetchAndMergeCapabilities(TargetsService targetsService) {
        Objects.requireNonNull(targetsService, "TargetsService cannot be null");
        return Uni.combine().all().unis(CapabilitiesHelper.fetchManagementTools(targetsService), CapabilitiesHelper.fetchToolsActivityState(targetsService), CapabilitiesHelper.fetchResourceProviders(targetsService), CapabilitiesHelper.fetchResourcesActivityState(targetsService)).with(CapabilitiesHelper::combineDataIntoCapabilities);
    }

    public static List<PrintableCapability> combineDataIntoCapabilities(List<?> responses) {
        if (responses.size() != 4) {
            throw new IndexOutOfBoundsException("Expected exactly 4 responses, got: " + responses.size());
        }
        List managementTools = (List)responses.get(0);
        Map toolsActivityState = (Map)responses.get(1);
        List resourceProviders = (List)responses.get(2);
        Map resourcesActivityState = (Map)responses.get(3);
        Map<String, List<ActivityRecord>> mergedActivityStates = CapabilitiesHelper.mergeActivityStates(toolsActivityState, resourcesActivityState);
        List allServiceTargets = Stream.concat(managementTools.stream(), resourceProviders.stream()).toList();
        return allServiceTargets.stream().map(target -> CapabilitiesHelper.createPrintableCapability(target, mergedActivityStates)).toList();
    }

    public static Map<String, List<ActivityRecord>> mergeActivityStates(Map<String, List<ActivityRecord>> toolsActivityState, Map<String, List<ActivityRecord>> resourcesActivityState) {
        Objects.requireNonNull(toolsActivityState, "Tools activity state map cannot be null");
        Objects.requireNonNull(resourcesActivityState, "Resources activity state map cannot be null");
        return Stream.concat(toolsActivityState.entrySet().stream(), resourcesActivityState.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, CapabilitiesHelper::getActivityRecords, (existingList, newList) -> Stream.concat(existingList.stream(), newList.stream()).toList()));
    }

    private static List<ActivityRecord> getActivityRecords(Map.Entry<String, List<ActivityRecord>> entry) {
        List<ActivityRecord> value = entry.getValue();
        if (!value.isEmpty()) {
            return value.stream().filter(Objects::nonNull).toList();
        }
        return List.of();
    }

    public static ActivityRecord findActivityRecord(ServiceTarget serviceTarget, Map<String, List<ActivityRecord>> activityStates) {
        Objects.requireNonNull(serviceTarget, "ServiceTarget cannot be null");
        Objects.requireNonNull(activityStates, "Activity states map cannot be null");
        return Optional.ofNullable(activityStates.get(serviceTarget.getService())).orElse(List.of()).stream().filter(record -> record.getId().equals(serviceTarget.getId())).findFirst().orElse(null);
    }

    public static PrintableCapability createPrintableCapability(ServiceTarget serviceTarget, Map<String, List<ActivityRecord>> activityStates) {
        Objects.requireNonNull(serviceTarget, "ServiceTarget cannot be null");
        Objects.requireNonNull(activityStates, "Activity states map cannot be null");
        ActivityRecord activityRecord = CapabilitiesHelper.findActivityRecord(serviceTarget, activityStates);
        return new PrintableCapability(Optional.ofNullable(serviceTarget.getService()).orElse(DEFAULT_STATUS), Optional.ofNullable(serviceTarget.getServiceType()).map(ServiceType::asValue).orElse(DEFAULT_STATUS), Optional.ofNullable(serviceTarget.getHost()).orElse(DEFAULT_STATUS), serviceTarget.getPort(), CapabilitiesHelper.determineServiceStatus(activityRecord), CapabilitiesHelper.formatLastSeenTimestamp(activityRecord), CapabilitiesHelper.processServiceConfigurations(Map.of()));
    }

    public static Uni<List<ServiceTarget>> fetchManagementTools(TargetsService targetsService) {
        Objects.requireNonNull(targetsService, "TargetsService cannot be null");
        return CapabilitiesHelper.executeApiCall(() -> ((TargetsService)targetsService).toolsList(), List.of());
    }

    public static Uni<Map<String, List<ActivityRecord>>> fetchToolsActivityState(TargetsService targetsService) {
        Objects.requireNonNull(targetsService, "TargetsService cannot be null");
        return CapabilitiesHelper.executeApiCall(() -> ((TargetsService)targetsService).toolsState(), Map.of());
    }

    public static Uni<List<ServiceTarget>> fetchResourceProviders(TargetsService targetsService) {
        Objects.requireNonNull(targetsService, "TargetsService cannot be null");
        return CapabilitiesHelper.executeApiCall(() -> ((TargetsService)targetsService).resourcesList(), List.of());
    }

    public static Uni<Map<String, List<ActivityRecord>>> fetchResourcesActivityState(TargetsService targetsService) {
        Objects.requireNonNull(targetsService, "TargetsService cannot be null");
        return CapabilitiesHelper.executeApiCall(() -> ((TargetsService)targetsService).resourcesState(), Map.of());
    }

    public static <T> Uni<T> executeApiCall(Supplier<WanakuResponse<T>> apiCall, T defaultValue) {
        Objects.requireNonNull(apiCall, "API call supplier cannot be null");
        try {
            WanakuResponse<T> response = apiCall.get();
            return response.error() != null ? Uni.createFrom().item(defaultValue) : Uni.createFrom().item(response.data());
        }
        catch (Exception e) {
            throw new WanakuException("API call failed.", (Throwable)e);
        }
    }

    public static String determineServiceStatus(ActivityRecord activityRecord) {
        if (activityRecord == null) {
            return DEFAULT_STATUS;
        }
        return activityRecord.isActive() ? ACTIVE_STATUS : INACTIVE_STATUS;
    }

    public static String formatLastSeenTimestamp(ActivityRecord activityRecord) {
        return Optional.ofNullable(activityRecord).map(ActivityRecord::getLastSeen).map(instant -> instant.atZone(ZoneId.systemDefault())).map(zonedDateTime -> zonedDateTime.format(VERBOSE_TIMESTAMP_FORMATTER)).orElse("");
    }

    public static List<PrintableCapabilityConfiguration> processServiceConfigurations(Map<String, String> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            return List.of();
        }
        return configurations.entrySet().stream().map(entry -> new PrintableCapabilityConfiguration((String)entry.getKey(), (String)entry.getValue())).toList();
    }

    public static void printCapabilities(List<PrintableCapability> capabilities, WanakuPrinter printer) {
        Objects.requireNonNull(capabilities, "Capabilities list cannot be null");
        Objects.requireNonNull(printer, "Printer cannot be null");
        printer.printTable(capabilities, COLUMNS);
    }

    public static void printCapability(PrintableCapability capability, WanakuPrinter printer) {
        Objects.requireNonNull(capability, "Capability cannot be null");
        Objects.requireNonNull(printer, "Printer cannot be null");
        printer.printAsMap(capability, COLUMNS);
    }

    @RegisterForReflection
    public record PrintableCapability(String service, String serviceType, String host, int port, String status, String lastSeen, List<PrintableCapabilityConfiguration> configurations) {
        public PrintableCapability {
            service = Objects.requireNonNullElse(service, "");
            serviceType = Objects.requireNonNullElse(serviceType, "");
            host = Objects.requireNonNullElse(host, "");
            status = Objects.requireNonNullElse(status, "");
            lastSeen = Objects.requireNonNullElse(lastSeen, "");
            configurations = Objects.requireNonNullElse(configurations, List.of());
        }
    }

    @RegisterForReflection
    public record PrintableCapabilityConfiguration(String name, String description) {
        public PrintableCapabilityConfiguration {
            name = Objects.requireNonNullElse(name, "");
            description = Objects.requireNonNullElse(description, "");
        }
    }
}

