/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.types.discovery.ActivityRecord;
import ai.wanaku.cli.main.support.CapabilitiesHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetsHelper {
    private TargetsHelper() {
    }

    public static List<Map<String, String>> getPrintableTargets(Map<String, List<ActivityRecord>> states) {
        if (states == null) {
            throw new IllegalArgumentException("States map cannot be null");
        }
        return states.entrySet().stream().filter(entry -> entry.getValue() != null).flatMap(entry -> ((List)entry.getValue()).stream().filter(Objects::nonNull).map(activityRecord -> TargetsHelper.createTargetMap((String)entry.getKey(), activityRecord))).toList();
    }

    public static Map<String, String> createTargetMap(String serviceName, ActivityRecord activityRecord) {
        HashMap<String, String> targetMap = new HashMap<String, String>();
        targetMap.put("id", activityRecord.getId());
        targetMap.put("service", serviceName);
        targetMap.put("active", String.valueOf(activityRecord.isActive()));
        targetMap.put("last_seen", CapabilitiesHelper.formatLastSeenTimestamp(activityRecord));
        return targetMap;
    }
}

