/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.types.ToolReference;
import ai.wanaku.api.types.WanakuResponse;
import ai.wanaku.cli.main.support.ResponseHelper;
import ai.wanaku.core.services.api.ToolsService;
import io.quarkus.rest.client.reactive.QuarkusRestClientBuilder;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class ToolHelper {
    private ToolHelper() {
    }

    public static void importToolset(List<ToolReference> toolReferences, String host) throws IOException {
        ToolsService toolsService = (ToolsService)QuarkusRestClientBuilder.newBuilder().baseUri(URI.create(host)).build(ToolsService.class);
        for (ToolReference toolReference : toolReferences) {
            try {
                WanakuResponse wanakuResponse = toolsService.add(toolReference);
            }
            catch (WebApplicationException ex) {
                Response response = ex.getResponse();
                if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    System.err.printf("There is no downstream service capable of handling requests of the given type (%s): %s%n", toolReference.getType(), response.getStatusInfo().getReasonPhrase());
                    System.exit(1);
                    continue;
                }
                ResponseHelper.commonResponseErrorHandler(response);
            }
        }
    }

    public static void importToolset(ToolReference toolReference, String host) throws IOException {
        ToolHelper.importToolset(List.of(toolReference), host);
    }
}

