/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import ai.wanaku.api.types.InputSchema;
import ai.wanaku.api.types.Property;
import ai.wanaku.api.types.ToolReference;
import ai.wanaku.cli.main.support.FileHelper;
import ai.wanaku.cli.main.support.StringHelper;
import ai.wanaku.core.util.CollectionsHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.util.ResolverFully;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;

public class ToolsGenerateHelper {
    private static final Logger LOG = Logger.getLogger(ToolsGenerateHelper.class);
    private static final String HTTP_TOOL_TYPE = "http";
    private static final String DEFAULT_OUTPUT_FILENAME = "out.json";
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{(.+?)\\}");

    private ToolsGenerateHelper() {
    }

    public static OpenAPI loadAndResolveOpenAPI(String specLocation) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setResolveFully(true);
        OpenAPI openAPI = new OpenAPIV3Parser().read(specLocation, null, options);
        if (openAPI != null) {
            new ResolverFully().resolveFully(openAPI);
        }
        return openAPI;
    }

    public static String determineBaseUrl(OpenAPI openAPI, String serverUrl, Integer serverIndex, Map<String, String> serverVariables) {
        if (StringUtils.isNotBlank((CharSequence)serverUrl)) {
            return serverUrl;
        }
        if (CollectionsHelper.isEmpty((Collection)openAPI.getServers())) {
            LOG.error((Object)"No servers found in the OpenAPI specification");
            System.err.println("No servers found in the OpenAPI specification or specified in the 'serverUrl' parameter");
            System.exit(-1);
        }
        int index = serverIndex != null ? serverIndex : 0;
        Server server = (Server)openAPI.getServers().get(index);
        if (server.getVariables() == null || server.getVariables().isEmpty()) {
            return server.getUrl();
        }
        return ToolsGenerateHelper.interpolateServerUrl(server, serverVariables);
    }

    public static List<ToolReference> generateToolReferences(OpenAPI openAPI, String baseUrl) {
        return openAPI.getPaths().entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).map(entry -> ToolsGenerateHelper.pathItem2ToolReferences(baseUrl, (String)entry.getKey(), (PathItem)entry.getValue())).flatMap(Collection::stream).toList();
    }

    public static void writeOutput(List<ToolReference> toolReferences, String output) throws Exception {
        try (PrintWriter out = ToolsGenerateHelper.getOutputPrintWriter(output);){
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)out, toolReferences);
        }
        catch (Exception e) {
            LOG.trace((Object)"Error writing toolset", (Throwable)e);
            throw e;
        }
    }

    public static List<ToolReference> pathItem2ToolReferences(String baseUrl, String path, PathItem pathItem) {
        if (pathItem == null) {
            return List.of();
        }
        record OperationEntry(String method, Operation operation) {
        }
        return Stream.of(new OperationEntry("GET", pathItem.getGet()), new OperationEntry("POST", pathItem.getPost()), new OperationEntry("PUT", pathItem.getPut()), new OperationEntry("DELETE", pathItem.getDelete()), new OperationEntry("PATCH", pathItem.getPatch()), new OperationEntry("OPTIONS", pathItem.getOptions()), new OperationEntry("HEAD", pathItem.getHead()), new OperationEntry("TRACE", pathItem.getTrace())).filter(entry -> entry.operation() != null).map(entry -> ToolsGenerateHelper.operation2ToolReference(pathItem, entry.operation(), baseUrl, path, entry.method())).toList();
    }

    public static ToolReference operation2ToolReference(PathItem pathItem, Operation operation, String baseUrl, String path, String method) {
        List parameters;
        ToolReference toolReference = new ToolReference();
        toolReference.setName(operation.getOperationId());
        toolReference.setDescription(operation.getDescription());
        toolReference.setType(HTTP_TOOL_TYPE);
        String uri = ToolsGenerateHelper.determineOperationUri(operation, baseUrl);
        toolReference.setUri(ToolsGenerateHelper.toolReferenceUrl(uri, path));
        List list = parameters = pathItem.getParameters() != null ? pathItem.getParameters() : List.of();
        if (operation.getParameters() != null) {
            parameters = Stream.concat(operation.getParameters().stream(), parameters.stream()).toList();
        }
        InputSchema inputSchema = ToolsGenerateHelper.parameters2InputSchema(parameters, operation.getRequestBody());
        ToolsGenerateHelper.addHttpMethodProperty(inputSchema, method);
        toolReference.setInputSchema(inputSchema);
        return toolReference;
    }

    public static String determineOperationUri(Operation operation, String baseUrl) {
        return Optional.ofNullable(baseUrl).orElseGet(() -> Optional.ofNullable(operation.getServers()).filter(CollectionsHelper::isNotEmpty).flatMap(servers -> servers.stream().filter(server -> StringHelper.isNotEmpty(server.getUrl())).findFirst().map(Server::getUrl)).orElse(baseUrl));
    }

    public static void addHttpMethodProperty(InputSchema inputSchema, String method) {
        Property property = new Property();
        property.setTarget("header");
        property.setType("string");
        property.setScope("service");
        property.setDescription("HTTP method to use when call the service.");
        property.setValue(method);
        inputSchema.getProperties().put("CamelHttpMethod", property);
    }

    public static InputSchema parameters2InputSchema(List<Parameter> parameters, RequestBody requestBody) {
        ArrayList<String> requiredParams = new ArrayList<String>();
        HashMap<String, Property> properties = new HashMap<String, Property>();
        InputSchema inputSchema = new InputSchema();
        inputSchema.setType("object");
        inputSchema.setRequired(requiredParams);
        inputSchema.setProperties(properties);
        parameters.forEach(parameter -> {
            properties.put(parameter.getName(), ToolsGenerateHelper.parameter2Property(parameter));
            if (Boolean.TRUE.equals(parameter.getRequired())) {
                requiredParams.add(parameter.getName());
            }
        });
        if (requestBody != null) {
            if (Boolean.TRUE.equals(requestBody.getRequired())) {
                requiredParams.add("wanaku_body");
            }
            Property body = new Property();
            body.setType("string");
            properties.put("wanaku_body", body);
        }
        return inputSchema;
    }

    public static Property parameter2Property(Parameter parameter) {
        Property property = new Property();
        property.setDescription(parameter.getDescription());
        property.setType("string");
        property.setScope("service");
        switch (parameter.getIn()) {
            case "header": {
                property.setTarget("header");
                break;
            }
            case "cookie": {
                property.setTarget("cookie");
            }
        }
        return property;
    }

    public static String toolReferenceUrl(String baseUrl, String path) {
        return baseUrl + PARAMETER_PATTERN.matcher(path).replaceAll(matchResult -> String.format("{parameter.value('%s')}", matchResult.group(1)));
    }

    public static String interpolateServerUrl(Server server, Map<String, String> variables) {
        String result = server.getUrl();
        if (CollectionsHelper.isEmpty((Map)server.getVariables())) {
            return result;
        }
        Map<String, String> replacements = server.getVariables().entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((ServerVariable)e.getValue()).getDefault())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (CollectionsHelper.isNotEmpty(variables)) {
            variables = variables.entrySet().stream().filter(e -> StringHelper.isNotEmpty((String)e.getKey()) && StringHelper.isNotEmpty((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            replacements.putAll(variables);
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    public static PrintWriter getOutputPrintWriter(String output) throws Exception {
        Path parent;
        if (StringHelper.isEmpty(output)) {
            return new PrintWriter(System.out);
        }
        Path outputPath = Paths.get(output, new String[0]);
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            String newFilePath = outputPath.resolve(DEFAULT_OUTPUT_FILENAME).toString();
            System.err.println("Warning: outputFile file " + output + " is a directory. The tools list will be written to " + newFilePath);
            outputPath = Paths.get(newFilePath, new String[0]);
        }
        if (Files.exists(outputPath, new LinkOption[0])) {
            String errorMessage = "Output file " + output + " already exists.";
            System.err.println(errorMessage);
            throw new Exception(errorMessage);
        }
        Path path = parent = outputPath.getParent() == null ? Path.of(".", new String[0]) : outputPath.getParent();
        if (FileHelper.cannotWriteToDirectory(parent)) {
            String errorMessage = "Cannot write to directory: " + String.valueOf(parent);
            System.err.println(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            return new PrintWriter(new FileWriter(outputPath.toString()));
        }
        catch (IOException e) {
            String errorMessage = "Could not open outputFile file " + output + " :" + e.getMessage();
            LOG.error((Object)errorMessage);
            System.err.println(errorMessage);
            throw new Exception(errorMessage);
        }
    }
}

