/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.cli.main.support;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.builtins.ConfigurationPath;
import org.jline.builtins.Styles;
import org.jline.console.Printer;
import org.jline.console.impl.DefaultPrinter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class WanakuPrinter
extends DefaultPrinter {
    private static final AttributedStyle ERROR_STYLE = AttributedStyle.BOLD.foreground(1);
    private static final AttributedStyle WARNING_STYLE = AttributedStyle.DEFAULT.foreground(3);
    private static final AttributedStyle INFO_STYLE = AttributedStyle.DEFAULT.foreground(4);
    private static final AttributedStyle SUCCESS_STYLE = AttributedStyle.BOLD.foreground(2);
    private static final String EXCEPTION_MODE_STACK = "stack";
    private static final String EXCEPTION_OPTION_KEY = "exception";
    private static final Map<String, Object> DEFAULT_TABLE_OPTIONS = Collections.unmodifiableMap(Map.of("structsOnTable", Boolean.TRUE, "rowHighlight", Printer.TableRows.EVEN, "oneRowTable", Boolean.TRUE));
    private static final Map<String, Object> DEFAULT_MAP_OPTIONS = Map.of("structsOnTable", Boolean.FALSE, "rowHighlight", Printer.TableRows.EVEN, "oneRowTable", Boolean.FALSE);
    private final Terminal terminal;
    private final ObjectMapper objectMapper;

    public WanakuPrinter(ConfigurationPath configPath, Terminal terminal) {
        super(configPath);
        this.terminal = WanakuPrinter.validateNotNull(terminal, "Terminal cannot be null");
        this.objectMapper = new ObjectMapper();
    }

    public static Terminal terminalInstance() throws IOException {
        return TerminalBuilder.builder().system(true).jansi(true).color(true).build();
    }

    protected Terminal terminal() {
        return this.terminal;
    }

    public <T> void printTable(List<T> printables) {
        this.printTable(printables, new String[0]);
    }

    public <T> void printTable(List<T> printables, String ... columns) {
        this.printTable(DEFAULT_TABLE_OPTIONS, printables, columns);
    }

    public <T> void printTable(Map<String, Object> options, List<T> printables, String ... columns) {
        this.printTable(options, printables, this::convertToMap, columns);
    }

    public <T> void printTable(Map<String, Object> options, List<T> objectsToPrint, Function<T, Map<String, Object>> toMap, String ... columns) {
        if (objectsToPrint == null || objectsToPrint.isEmpty()) {
            return;
        }
        try {
            List<Map<String, Object>> mappedObjects = objectsToPrint.stream().map(toMap).toList();
            Map<String, Object> mergedOptions = this.createMergedOptions(options);
            if (columns != null && columns.length > 0) {
                mergedOptions.put("columns", Arrays.asList(columns));
            }
            this.println(mergedOptions, mappedObjects);
        }
        catch (Exception e) {
            this.printErrorMessage("Failed to print table: " + e.getMessage());
        }
    }

    public <T> void printAsMap(T object) {
        this.printAsMap(object, new String[0]);
    }

    public <T> void printAsMap(T object, String ... keys) {
        if (object == null) {
            return;
        }
        Map<String, Object> map = this.convertToMap(object);
        if (keys != null && keys.length > 0) {
            Set<String> keySet = Set.of(keys);
            map = map.entrySet().stream().filter(entry -> keySet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        try {
            this.println(DEFAULT_MAP_OPTIONS, map);
        }
        catch (Exception e) {
            this.printErrorMessage("Failed to print object: " + e.getMessage());
        }
    }

    public void printErrorMessage(String message) {
        if (message != null) {
            this.printStyledMessage(message, ERROR_STYLE);
        }
    }

    public void printWarningMessage(String message) {
        if (message != null) {
            this.printStyledMessage(message, WARNING_STYLE);
        }
    }

    public void printInfoMessage(String message) {
        if (message != null) {
            this.printStyledMessage(message, INFO_STYLE);
        }
    }

    public void printSuccessMessage(String message) {
        if (message != null) {
            this.printStyledMessage(message, SUCCESS_STYLE);
        }
    }

    protected void highlightAndPrint(Map<String, Object> options, Throwable exception) {
        if (exception == null) {
            return;
        }
        String exceptionMode = (String)options.getOrDefault(EXCEPTION_OPTION_KEY, EXCEPTION_MODE_STACK);
        if (EXCEPTION_MODE_STACK.equals(exceptionMode)) {
            exception.printStackTrace();
        } else {
            AttributedStringBuilder builder = new AttributedStringBuilder();
            builder.append((CharSequence)exception.getMessage(), Styles.prntStyle().resolve(".em"));
            builder.toAttributedString().println(this.terminal());
        }
    }

    private Map<String, Object> convertToMap(Object obj) {
        if (obj == null) {
            return Map.of();
        }
        try {
            return (Map)this.objectMapper.convertValue(obj, (TypeReference)new TypeReference<Map<String, Object>>(this){});
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert object to map: " + e.getMessage(), e);
        }
    }

    private void printStyledMessage(String message, AttributedStyle style) {
        AttributedString styledMessage = new AttributedStringBuilder().style(style).append((CharSequence)message).toAttributedString();
        this.terminal.writer().println(styledMessage.toAnsi());
        this.terminal.flush();
    }

    private Map<String, Object> createMergedOptions(Map<String, Object> customOptions) {
        HashMap<String, Object> merged = new HashMap<String, Object>(DEFAULT_TABLE_OPTIONS);
        if (customOptions != null) {
            merged.putAll(customOptions);
        }
        return merged;
    }

    private static <T> T validateNotNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }
}

