package ai.wanaku.core.exchange;

import static ai.wanaku.core.exchange.InquirerGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;

@jakarta.annotation.Generated(value = "by Mutiny Grpc generator", comments = "Source: inquiry.proto")
public final class MutinyInquirerGrpc implements io.quarkus.grpc.MutinyGrpc {

    private MutinyInquirerGrpc() {
    }

    public static MutinyInquirerStub newMutinyStub(io.grpc.Channel channel) {
        return new MutinyInquirerStub(channel);
    }

    /**
     * <pre>
     *  The inquirer exchange service definition.
     * </pre>
     */
    public static class MutinyInquirerStub extends io.grpc.stub.AbstractStub<MutinyInquirerStub> implements io.quarkus.grpc.MutinyStub {

        private InquirerGrpc.InquirerStub delegateStub;

        private MutinyInquirerStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = InquirerGrpc.newStub(channel);
        }

        private MutinyInquirerStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = InquirerGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected MutinyInquirerStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new MutinyInquirerStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Invokes a tool
         * </pre>
         */
        public io.smallrye.mutiny.Uni<ai.wanaku.core.exchange.InquireReply> inquire(ai.wanaku.core.exchange.InquireRequest request) {
            return io.quarkus.grpc.stubs.ClientCalls.oneToOne(request, delegateStub::inquire);
        }
    }

    /**
     * <pre>
     *  The inquirer exchange service definition.
     * </pre>
     */
    public static abstract class InquirerImplBase implements io.grpc.BindableService {

        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public InquirerImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Invokes a tool
         * </pre>
         */
        public io.smallrye.mutiny.Uni<ai.wanaku.core.exchange.InquireReply> inquire(ai.wanaku.core.exchange.InquireRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override
        public io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor()).addMethod(ai.wanaku.core.exchange.InquirerGrpc.getInquireMethod(), asyncUnaryCall(new MethodHandlers<ai.wanaku.core.exchange.InquireRequest, ai.wanaku.core.exchange.InquireReply>(this, METHODID_INQUIRE, compression))).build();
        }
    }

    private static final int METHODID_INQUIRE = 0;

    private static final class MethodHandlers<Req, Resp> implements io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>, io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final InquirerImplBase serviceImpl;

        private final int methodId;

        private final String compression;

        MethodHandlers(InquirerImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                case METHODID_INQUIRE:
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((ai.wanaku.core.exchange.InquireRequest) request, (io.grpc.stub.StreamObserver<ai.wanaku.core.exchange.InquireReply>) responseObserver, compression, serviceImpl::inquire);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }
}
