/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.core.exchange;

import ai.wanaku.core.exchange.ToolInvokeRequest;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public record ParsedToolInvokeRequest(String uri, String body) {
    public static ParsedToolInvokeRequest parseRequest(ToolInvokeRequest toolInvokeRequest) {
        String uri = toolInvokeRequest.getUri();
        return ParsedToolInvokeRequest.parseRequest(uri, toolInvokeRequest);
    }

    public static ParsedToolInvokeRequest parseRequest(String uri, ToolInvokeRequest toolInvokeRequest) {
        String body = null;
        for (Map.Entry<String, String> t : toolInvokeRequest.getArgumentsMap().entrySet()) {
            if (!t.getKey().equals("_body")) {
                String o = toolInvokeRequest.getArgumentsMap().get(t.getKey());
                String encoded = URLEncoder.encode(o.toString(), StandardCharsets.UTF_8);
                uri = uri.replace(String.format("{%s}", t.getKey()), encoded);
                continue;
            }
            body = toolInvokeRequest.getArgumentsMap().get("_body").toString();
        }
        if (body == null) {
            body = "";
        }
        return new ParsedToolInvokeRequest(uri, body);
    }
}

