package ai.wanaku.core.exchange;

import static ai.wanaku.core.exchange.ToolInvokerGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;

@jakarta.annotation.Generated(value = "by Mutiny Grpc generator", comments = "Source: toolrequest.proto")
public final class MutinyToolInvokerGrpc implements io.quarkus.grpc.MutinyGrpc {

    private MutinyToolInvokerGrpc() {
    }

    public static MutinyToolInvokerStub newMutinyStub(io.grpc.Channel channel) {
        return new MutinyToolInvokerStub(channel);
    }

    /**
     * <pre>
     *  The tool exchange service definition.
     * </pre>
     */
    public static class MutinyToolInvokerStub extends io.grpc.stub.AbstractStub<MutinyToolInvokerStub> implements io.quarkus.grpc.MutinyStub {

        private ToolInvokerGrpc.ToolInvokerStub delegateStub;

        private MutinyToolInvokerStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = ToolInvokerGrpc.newStub(channel);
        }

        private MutinyToolInvokerStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ToolInvokerGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected MutinyToolInvokerStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new MutinyToolInvokerStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Invokes a tool
         * </pre>
         */
        public io.smallrye.mutiny.Uni<ai.wanaku.core.exchange.ToolInvokeReply> invokeTool(ai.wanaku.core.exchange.ToolInvokeRequest request) {
            return io.quarkus.grpc.stubs.ClientCalls.oneToOne(request, delegateStub::invokeTool);
        }
    }

    /**
     * <pre>
     *  The tool exchange service definition.
     * </pre>
     */
    public static abstract class ToolInvokerImplBase implements io.grpc.BindableService {

        private String compression;

        /**
         * Set whether the server will try to use a compressed response.
         *
         * @param compression the compression, e.g {@code gzip}
         */
        public ToolInvokerImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * <pre>
         *  Invokes a tool
         * </pre>
         */
        public io.smallrye.mutiny.Uni<ai.wanaku.core.exchange.ToolInvokeReply> invokeTool(ai.wanaku.core.exchange.ToolInvokeRequest request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override
        public io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor()).addMethod(ai.wanaku.core.exchange.ToolInvokerGrpc.getInvokeToolMethod(), asyncUnaryCall(new MethodHandlers<ai.wanaku.core.exchange.ToolInvokeRequest, ai.wanaku.core.exchange.ToolInvokeReply>(this, METHODID_INVOKE_TOOL, compression))).build();
        }
    }

    private static final int METHODID_INVOKE_TOOL = 0;

    private static final class MethodHandlers<Req, Resp> implements io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>, io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>, io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final ToolInvokerImplBase serviceImpl;

        private final int methodId;

        private final String compression;

        MethodHandlers(ToolInvokerImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                case METHODID_INVOKE_TOOL:
                    io.quarkus.grpc.stubs.ServerCalls.oneToOne((ai.wanaku.core.exchange.ToolInvokeRequest) request, (io.grpc.stub.StreamObserver<ai.wanaku.core.exchange.ToolInvokeReply>) responseObserver, compression, serviceImpl::invokeTool);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch(methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }
}
