/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.core.exchange;

import ai.wanaku.core.exchange.ToolInvokeRequest;
import ai.wanaku.core.uri.Parameter;
import ai.wanaku.core.uri.URIHelper;
import ai.wanaku.core.uri.URIParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public record ParsedToolInvokeRequest(String uri, String body, Map<String, String> headers) {
    public static ParsedToolInvokeRequest parseRequest(ToolInvokeRequest toolInvokeRequest) {
        String uri = toolInvokeRequest.getUri();
        return ParsedToolInvokeRequest.parseRequest(uri, toolInvokeRequest);
    }

    public static ParsedToolInvokeRequest parseRequest(String uri, ToolInvokeRequest toolInvokeRequest) {
        Map<String, String> argumentsMap = toolInvokeRequest.getArgumentsMap();
        if (argumentsMap == null) {
            argumentsMap = Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(argumentsMap);
        map.put("parameter", (String)new Parameter(argumentsMap));
        String parsedUri = URIParser.parse((String)uri, map);
        parsedUri = URIHelper.addQueryParameters((String)parsedUri, toolInvokeRequest.getServiceConfigurationsMap());
        String body = toolInvokeRequest.getBody();
        Map<String, String> headers = toolInvokeRequest.getHeadersMap();
        return new ParsedToolInvokeRequest(parsedUri, body, headers);
    }
}

