/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.core.service.discovery;

import ai.wanaku.api.types.management.Configuration;
import ai.wanaku.api.types.management.Configurations;
import ai.wanaku.api.types.management.Service;
import ai.wanaku.api.types.management.State;
import ai.wanaku.core.mcp.providers.ServiceRegistry;
import ai.wanaku.core.mcp.providers.ServiceTarget;
import ai.wanaku.core.mcp.providers.ServiceType;
import ai.wanaku.core.service.discovery.ReservedKeys;
import io.quarkus.arc.lookup.LookupIfProperty;
import io.quarkus.runtime.ShutdownEvent;
import io.valkey.Jedis;
import io.valkey.JedisPool;
import io.valkey.StreamEntryID;
import io.valkey.params.XAddParams;
import io.valkey.resps.StreamEntry;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
@LookupIfProperty(name="wanaku.service.persistence", stringValue="valkey")
public class ValkeyRegistry
implements ServiceRegistry {
    private static final Logger LOG = Logger.getLogger(ValkeyRegistry.class);
    @Inject
    JedisPool jedisPool;
    @ConfigProperty(name="wanaku.service.expire-time", defaultValue="60")
    int expireTime;

    public void register(ServiceTarget serviceTarget, Map<String, String> configurations) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String serviceKey = ReservedKeys.getServiceKey(serviceTarget.getServiceType());
            jedis.sadd(serviceKey, new String[]{serviceTarget.getService()});
            jedis.hset(serviceTarget.getService(), "wanaku-target-address", serviceTarget.toAddress());
            jedis.hset(serviceTarget.getService(), "wanaku-target-type", serviceTarget.getServiceType().asValue());
            LOG.infof("Service %s with target %s registered", (Object)serviceTarget.getService(), (Object)serviceTarget.toAddress());
            for (Map.Entry<String, String> entry : configurations.entrySet()) {
                if (jedis.hexists(serviceTarget.getService(), entry.getKey())) continue;
                LOG.infof("Registering configuration %s for service %s", (Object)entry.getKey(), (Object)serviceTarget.getService());
                Configuration configuration = new Configuration();
                configuration.setDescription(entry.getValue());
                jedis.hset(serviceTarget.getService(), entry.getKey(), configuration.toJson());
            }
            jedis.expire(serviceTarget.getService(), (long)this.expireTime);
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to register service %s: %s", (Object)serviceTarget.getService(), (Object)e.getMessage());
        }
    }

    public void deregister(String service, ServiceType serviceType) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String serviceKey = ReservedKeys.getServiceKey(serviceType);
            jedis.srem(serviceKey, new String[]{service});
            LOG.infof("Service %s registered", (Object)service);
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to register service %s: %s", (Object)service, (Object)e.getMessage());
        }
    }

    public void saveState(String service, boolean healthy, String message) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Map<String, String> state = Map.of("service", service, "healthy", Boolean.toString(healthy), "message", healthy ? "healthy" : message);
            jedis.xadd(ValkeyRegistry.stateKey(service), state, XAddParams.xAddParams());
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to save state for %s: %s", (Object)service, (Object)e.getMessage());
        }
    }

    public List<State> getState(String service, int count) {
        ArrayList<State> arrayList;
        block9: {
            Jedis jedis = this.jedisPool.getResource();
            try {
                String stateKey = ValkeyRegistry.stateKey(service);
                Instant now = Instant.now();
                long endEpoch = now.toEpochMilli();
                long startEpoch = now.minusSeconds(60L).toEpochMilli();
                List streamEntries = jedis.xrange(stateKey, new StreamEntryID(startEpoch), new StreamEntryID(endEpoch));
                ArrayList<State> states = new ArrayList<State>(streamEntries.size());
                for (StreamEntry streamEntry : streamEntries) {
                    LOG.debugf("Entry %s", (Object)streamEntry);
                    Map fields = streamEntry.getFields();
                    String serviceName = (String)fields.get("service");
                    String message = (String)fields.get("message");
                    String healthy = (String)fields.get("healthy");
                    State state = new State(serviceName, Boolean.parseBoolean(healthy), message);
                    states.add(state);
                }
                arrayList = states;
                if (jedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.errorf((Throwable)e, "Failed to get state for %s: %s", (Object)service, (Object)e.getMessage());
                    return List.of();
                }
            }
            jedis.close();
        }
        return arrayList;
    }

    private static String stateKey(String service) {
        return "state:" + service;
    }

    public Service getService(String service) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Service service2 = ValkeyRegistry.newService(jedis, service);
            return service2;
        }
    }

    public Map<String, Service> getEntries(ServiceType serviceType) {
        HashMap<String, Service> entries = new HashMap<String, Service>();
        try (Jedis jedis = this.jedisPool.getResource();){
            String serviceKey = ReservedKeys.getServiceKey(serviceType);
            Set services = jedis.smembers(serviceKey);
            for (String key : services) {
                Service service = ValkeyRegistry.newService(jedis, key);
                if (service == null) continue;
                entries.put(key, service);
            }
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed list services: %s", (Object)e.getMessage());
        }
        return entries;
    }

    public void update(String target, String option, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String jsonConfiguration = jedis.hget(target, option);
            Configuration configuration = Configuration.fromJson((String)jsonConfiguration);
            configuration.setValue(value);
            jedis.hset(target, option, configuration.toJson());
            LOG.infof("Option %s updated for Service %s", (Object)option, (Object)target);
        }
        catch (Exception e) {
            LOG.errorf((Throwable)e, "Failed to update option %s for service %s: %s", (Object)option, (Object)target, (Object)e.getMessage());
        }
    }

    private static Service newService(Jedis jedis, String key) {
        Set configs = jedis.hkeys(key);
        return ValkeyRegistry.toService(jedis, key, configs);
    }

    private static Service toService(Jedis jedis, String key, Set<String> configs) {
        String address = jedis.hget(key, "wanaku-target-address");
        if (address == null) {
            return null;
        }
        Service service = new Service();
        service.setTarget(address);
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        for (String config : configs) {
            if (ReservedKeys.ALL_KEYS.contains(config)) continue;
            Configuration configuration = ValkeyRegistry.toConfiguration(jedis, key, config);
            configurationMap.put(config, configuration);
        }
        Configurations configurations = new Configurations();
        configurations.setConfigurations(configurationMap);
        service.setConfigurations(configurations);
        return service;
    }

    private static Configuration toConfiguration(Jedis jedis, String key, String config) {
        String jsonConfiguration = jedis.hget(key, config);
        return Configuration.fromJson((String)jsonConfiguration);
    }

    void shutdown(@Observes ShutdownEvent shutdownEvent) {
        this.jedisPool.close();
    }
}

