/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.provider.ftp.file;

import ai.wanaku.api.exceptions.InvalidResponseTypeException;
import ai.wanaku.api.exceptions.NonConvertableResponseException;
import ai.wanaku.core.exchange.ResourceRequest;
import ai.wanaku.core.services.config.WanakuProviderConfig;
import ai.wanaku.core.services.provider.AbstractResourceDelegate;
import ai.wanaku.core.services.util.URIHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.file.GenericFile;

@ApplicationScoped
public class FileResourceDelegate
extends AbstractResourceDelegate {
    @Inject
    WanakuProviderConfig config;

    protected String getEndpointUri(ResourceRequest request, Map<String, String> parameters) {
        String path;
        File file = new File(request.getLocation());
        if (file.isDirectory()) {
            path = file.getAbsolutePath();
            parameters.putIfAbsent("recursive", "true");
        } else {
            path = file.getParent();
            parameters.putIfAbsent("fileName", file.getName());
        }
        return URIHelper.buildUri((String)this.config.baseUri(), (String)path, parameters);
    }

    protected List<String> coerceResponse(Object response) throws InvalidResponseTypeException, NonConvertableResponseException {
        if (response instanceof GenericFile) {
            GenericFile genericFile = (GenericFile)response;
            String fileName = genericFile.getAbsoluteFilePath();
            try {
                Path path = Path.of(fileName, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    return List.of(Files.readString(path));
                }
                throw new NonConvertableResponseException("The file does not exist: " + fileName);
            }
            catch (IOException e) {
                throw new NonConvertableResponseException((Throwable)e);
            }
        }
        if (response == null) {
            throw new InvalidResponseTypeException("Unable the read the file: no response (does the file exist?)");
        }
        throw new InvalidResponseTypeException("Invalid response type from the consumer: " + response.getClass().getName());
    }
}

