/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.provider.ftp;

import ai.wanaku.api.exceptions.InvalidResponseTypeException;
import ai.wanaku.api.exceptions.NonConvertableResponseException;
import ai.wanaku.core.exchange.ResourceRequest;
import ai.wanaku.core.services.config.WanakuProviderConfig;
import ai.wanaku.core.services.provider.AbstractResourceDelegate;
import ai.wanaku.core.services.util.URIHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.file.GenericFile;
import org.jboss.logging.Logger;

@ApplicationScoped
public class FTPResourceDelegate
extends AbstractResourceDelegate {
    private static final Logger LOG = Logger.getLogger(FTPResourceDelegate.class);
    @Inject
    WanakuProviderConfig config;

    protected String getEndpointUri(ResourceRequest request, Map<String, String> parameters) {
        return URIHelper.buildUri((String)request.getLocation(), parameters);
    }

    protected List<String> coerceResponse(Object response) throws InvalidResponseTypeException, NonConvertableResponseException {
        if (response instanceof GenericFile) {
            GenericFile genericFile = (GenericFile)response;
            Object body = genericFile.getBody();
            if (body instanceof byte[]) {
                byte[] bytes = (byte[])body;
                return List.of(new String(bytes));
            }
            throw new NonConvertableResponseException("The response body is not a byte array");
        }
        throw new InvalidResponseTypeException("Invalid response type from the consumer: " + response.getClass().getName());
    }

    public Map<String, String> serviceConfigurations() {
        Map configurations = this.config.service().configurations();
        return this.componentOptions(this.config.name(), configurations);
    }
}

