/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.provider.s3;

import ai.wanaku.api.exceptions.InvalidResponseTypeException;
import ai.wanaku.api.exceptions.ResourceNotFoundException;
import ai.wanaku.core.exchange.ResourceRequest;
import ai.wanaku.core.services.common.ServiceOptions;
import ai.wanaku.core.services.config.WanakuProviderConfig;
import ai.wanaku.core.services.provider.AbstractResourceDelegate;
import ai.wanaku.core.uri.URIHelper;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class S3ResourceDelegate
extends AbstractResourceDelegate {
    @Inject
    WanakuProviderConfig config;
    @Inject
    ServiceOptions serviceOptions;

    protected String getEndpointUri(ResourceRequest request, Map<String, String> parameters) {
        String[] locations = request.getLocation().split("/");
        if (locations.length < 2) {
            throw new IllegalArgumentException("Invalid location: " + request.getLocation() + " the location has to be in the form str1/str2.txt, where str1 is the bucket name and str2.txt the file on the bucket");
        }
        parameters.put("prefix", locations[locations.length - 1]);
        return "aws2-s3:" + URIHelper.buildUri((String)locations[0], parameters);
    }

    protected List<String> coerceResponse(Object response) throws InvalidResponseTypeException, ResourceNotFoundException {
        if (response == null) {
            throw new ResourceNotFoundException("File not found");
        }
        if (response instanceof byte[]) {
            byte[] bytes = (byte[])response;
            return List.of(new String(bytes));
        }
        throw new InvalidResponseTypeException("Invalid response type from the consumer: " + response.getClass().getName());
    }

    public Map<String, String> serviceConfigurations() {
        Map configurations = this.config.service().configurations();
        return this.serviceOptions.merge(this.config.name(), configurations);
    }
}

