/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers;

import ai.wanaku.core.mcp.common.resolvers.Resolver;
import ai.wanaku.core.util.IndexHelper;
import ai.wanaku.routers.proxies.Proxy;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

abstract class AbstractProvider<T extends Proxy, Y extends Resolver> {
    AbstractProvider() {
    }

    private static File createSettingsDirectory(String settingsDirectory) {
        File resourcesDir = new File(settingsDirectory);
        if (!resourcesDir.exists()) {
            resourcesDir.mkdirs();
        }
        return resourcesDir;
    }

    protected File initializeResourcesIndex(String resourcesPath, String fileName) {
        File settingsDirectory = AbstractProvider.createSettingsDirectory(resourcesPath);
        File indexFile = new File(settingsDirectory, fileName);
        try {
            if (!indexFile.exists()) {
                IndexHelper.saveResourcesIndex((File)indexFile, (List)Collections.EMPTY_LIST);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return indexFile;
    }

    abstract File initializeIndex();

    abstract Y getResolver();
}

