/*
 * Decompiled with CFR 0.152.
 */
package ai.wanaku.routers;

import ai.wanaku.core.mcp.common.resolvers.ResourceResolver;
import ai.wanaku.core.mcp.common.resolvers.util.NoopResourceResolver;
import ai.wanaku.routers.AbstractProvider;
import ai.wanaku.routers.proxies.ResourceProxy;
import ai.wanaku.routers.proxies.resources.ResourceAcquirerProxy;
import ai.wanaku.routers.resolvers.WanakuResourceResolver;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.io.File;
import picocli.CommandLine;

@ApplicationScoped
public class ResourcesProvider
extends AbstractProvider<ResourceProxy, ResourceResolver> {
    @Inject
    CommandLine.ParseResult parseResult;

    @Override
    @Produces
    ResourceResolver getResolver() {
        if (this.parseResult.isUsageHelpRequested() || this.parseResult.isVersionHelpRequested()) {
            return new NoopResourceResolver();
        }
        File resourcesIndexFile = this.initializeIndex();
        return new WanakuResourceResolver(resourcesIndexFile, new ResourceAcquirerProxy());
    }

    @Override
    protected File initializeIndex() {
        String indexPath = ((String)this.parseResult.matchedOptionValue("indexes-path", (Object)"${user.home}/.wanaku/router/")).replace("${user.home}", System.getProperty("user.home"));
        return this.initializeResourcesIndex(indexPath, "resources.json");
    }
}

